/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.subphase.highlight;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Query;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.regex.Regex;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MappedFieldType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.SourceFieldMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.QueryShardContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.SearchShardTarget;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.FetchSubPhase;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.subphase.highlight.Highlighter;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.subphase.highlight.HighlighterContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.subphase.highlight.SearchContextHighlight;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.internal.SearchContext;

public class HighlightPhase
implements FetchSubPhase {
    private final Map<String, Highlighter> highlighters;

    public HighlightPhase(Map<String, Highlighter> highlighters) {
        this.highlighters = highlighters;
    }

    @Override
    public void hitExecute(SearchContext context, FetchSubPhase.HitContext hitContext) {
        if (context.highlight() == null) {
            return;
        }
        this.hitExecute(context.shardTarget(), context.getQueryShardContext(), context.parsedQuery().query(), context.highlight(), hitContext);
    }

    public void hitExecute(SearchShardTarget shardTarget, QueryShardContext context, Query query, SearchContextHighlight highlight, FetchSubPhase.HitContext hitContext) {
        HashMap<String, HighlightField> highlightFields = new HashMap<String, HighlightField>();
        for (SearchContextHighlight.Field field : highlight.fields()) {
            SourceFieldMapper sourceFieldMapper;
            Collection<String> fieldNamesToHighlight = Regex.isSimpleMatchPattern(field.field()) ? context.getMapperService().simpleMatchToFullName(field.field()) : Collections.singletonList(field.field());
            if (highlight.forceSource(field) && !(sourceFieldMapper = context.getMapperService().documentMapper(hitContext.hit().getType()).sourceMapper()).enabled()) {
                throw new IllegalArgumentException("source is forced for fields " + fieldNamesToHighlight + " but type [" + hitContext.hit().getType() + "] has disabled _source");
            }
            boolean fieldNameContainsWildcards = field.field().contains("*");
            for (String fieldName : fieldNamesToHighlight) {
                HighlightField highlightField;
                Highlighter highlighter;
                MappedFieldType fieldType = context.getMapperService().fullName(fieldName);
                if (fieldType == null || fieldNameContainsWildcards && !fieldType.typeName().equals("text") && !fieldType.typeName().equals("keyword")) continue;
                String highlighterType = field.fieldOptions().highlighterType();
                if (highlighterType == null) {
                    highlighterType = "unified";
                }
                if ((highlighter = this.highlighters.get(highlighterType)) == null) {
                    throw new IllegalArgumentException("unknown highlighter type [" + highlighterType + "] for the field [" + fieldName + "]");
                }
                Query highlightQuery = field.fieldOptions().highlightQuery();
                if (highlightQuery == null) {
                    highlightQuery = query;
                }
                HighlighterContext highlighterContext = new HighlighterContext(fieldType.name(), field, fieldType, shardTarget, context, highlight, hitContext, highlightQuery);
                if (!highlighter.canHighlight(fieldType) && fieldNameContainsWildcards || (highlightField = highlighter.highlight(highlighterContext)) == null) continue;
                highlightFields.put(fieldName, new HighlightField(fieldName, highlightField.fragments()));
            }
        }
        hitContext.hit().highlightFields(highlightFields);
    }
}

