/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.collapse;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.IndexOptions;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParsingException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.Writeable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentObject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.KeywordFieldMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MappedFieldType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.NumberFieldMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.InnerHitBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.QueryShardContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.collapse.CollapseContext;

public class CollapseBuilder
implements Writeable,
ToXContentObject {
    public static final ParseField FIELD_FIELD = new ParseField("field", new String[0]);
    public static final ParseField INNER_HITS_FIELD = new ParseField("inner_hits", new String[0]);
    public static final ParseField MAX_CONCURRENT_GROUP_REQUESTS_FIELD = new ParseField("max_concurrent_group_searches", new String[0]);
    private static final ObjectParser<CollapseBuilder, Void> PARSER = new ObjectParser("collapse", CollapseBuilder::new);
    private String field;
    private List<InnerHitBuilder> innerHits = Collections.emptyList();
    private int maxConcurrentGroupRequests = 0;

    private CollapseBuilder() {
    }

    public CollapseBuilder(String field) {
        Objects.requireNonNull(field, "field must be non-null");
        this.field = field;
    }

    public CollapseBuilder(StreamInput in) throws IOException {
        this.field = in.readString();
        this.maxConcurrentGroupRequests = in.readVInt();
        this.innerHits = in.readList(InnerHitBuilder::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.field);
        out.writeVInt(this.maxConcurrentGroupRequests);
        out.writeList(this.innerHits);
    }

    public static CollapseBuilder fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    private CollapseBuilder setField(String field) {
        if (Strings.isEmpty(field)) {
            throw new IllegalArgumentException("field name is null or empty");
        }
        this.field = field;
        return this;
    }

    public CollapseBuilder setInnerHits(InnerHitBuilder innerHit) {
        this.innerHits = Collections.singletonList(innerHit);
        return this;
    }

    public CollapseBuilder setInnerHits(List<InnerHitBuilder> innerHits) {
        this.innerHits = innerHits;
        return this;
    }

    public CollapseBuilder setMaxConcurrentGroupRequests(int num) {
        if (num < 1) {
            throw new IllegalArgumentException("maxConcurrentGroupRequests` must be positive");
        }
        this.maxConcurrentGroupRequests = num;
        return this;
    }

    public String getField() {
        return this.field;
    }

    public List<InnerHitBuilder> getInnerHits() {
        return this.innerHits;
    }

    public int getMaxConcurrentGroupRequests() {
        return this.maxConcurrentGroupRequests;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.innerToXContent(builder);
        builder.endObject();
        return builder;
    }

    private void innerToXContent(XContentBuilder builder) throws IOException {
        builder.field(FIELD_FIELD.getPreferredName(), this.field);
        if (this.maxConcurrentGroupRequests > 0) {
            builder.field(MAX_CONCURRENT_GROUP_REQUESTS_FIELD.getPreferredName(), this.maxConcurrentGroupRequests);
        }
        if (!this.innerHits.isEmpty()) {
            if (this.innerHits.size() == 1) {
                builder.field(INNER_HITS_FIELD.getPreferredName(), this.innerHits.get(0));
            } else {
                builder.startArray(INNER_HITS_FIELD.getPreferredName());
                for (InnerHitBuilder innerHit : this.innerHits) {
                    innerHit.toXContent(builder, ToXContent.EMPTY_PARAMS);
                }
                builder.endArray();
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CollapseBuilder that = (CollapseBuilder)o;
        if (this.maxConcurrentGroupRequests != that.maxConcurrentGroupRequests) {
            return false;
        }
        if (!this.field.equals(that.field)) {
            return false;
        }
        return Objects.equals(this.innerHits, that.innerHits);
    }

    public int hashCode() {
        int result = Objects.hash(this.field, this.innerHits);
        result = 31 * result + this.maxConcurrentGroupRequests;
        return result;
    }

    public CollapseContext build(QueryShardContext queryShardContext) {
        MappedFieldType fieldType = queryShardContext.fieldMapper(this.field);
        if (fieldType == null) {
            throw new IllegalArgumentException("no mapping found for `" + this.field + "` in order to collapse on");
        }
        if (!(fieldType instanceof KeywordFieldMapper.KeywordFieldType) && !(fieldType instanceof NumberFieldMapper.NumberFieldType)) {
            throw new IllegalArgumentException("unknown type for collapse field `" + this.field + "`, only keywords and numbers are accepted");
        }
        if (!fieldType.hasDocValues()) {
            throw new IllegalArgumentException("cannot collapse on field `" + this.field + "` without `doc_values`");
        }
        if (fieldType.indexOptions() == IndexOptions.NONE && this.innerHits != null && !this.innerHits.isEmpty()) {
            throw new IllegalArgumentException("cannot expand `inner_hits` for collapse field `" + this.field + "`, only indexed field can retrieve `inner_hits`");
        }
        return new CollapseContext(this.field, fieldType, this.innerHits);
    }

    static {
        PARSER.declareString(CollapseBuilder::setField, FIELD_FIELD);
        PARSER.declareInt(CollapseBuilder::setMaxConcurrentGroupRequests, MAX_CONCURRENT_GROUP_REQUESTS_FIELD);
        PARSER.declareField((parser, builder, context) -> {
            XContentParser.Token currentToken = parser.currentToken();
            if (currentToken == XContentParser.Token.START_OBJECT) {
                builder.setInnerHits(InnerHitBuilder.fromXContent(parser));
            } else if (currentToken == XContentParser.Token.START_ARRAY) {
                ArrayList<InnerHitBuilder> innerHitBuilders = new ArrayList<InnerHitBuilder>();
                currentToken = parser.nextToken();
                while (currentToken != XContentParser.Token.END_ARRAY) {
                    if (currentToken != XContentParser.Token.START_OBJECT) {
                        throw new ParsingException(parser.getTokenLocation(), "Invalid token in inner_hits array", new Object[0]);
                    }
                    innerHitBuilders.add(InnerHitBuilder.fromXContent(parser));
                    currentToken = parser.nextToken();
                }
                builder.setInnerHits(innerHitBuilders);
            }
        }, INNER_HITS_FIELD, ObjectParser.ValueType.OBJECT_ARRAY);
    }
}

