/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.support;

import java.io.IOException;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Objects;
import java.util.function.BiFunction;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.Writeable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.time.DateUtils;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentObject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.script.Script;

public class MultiValuesSourceFieldConfig
implements Writeable,
ToXContentObject {
    private String fieldName;
    private Object missing;
    private Script script;
    private ZoneId timeZone;
    private static final String NAME = "field_config";
    public static final BiFunction<Boolean, Boolean, ObjectParser<Builder, Void>> PARSER = (scriptable, timezoneAware) -> {
        ObjectParser<Builder, Void> parser = new ObjectParser<Builder, Void>(NAME, Builder::new);
        parser.declareString(Builder::setFieldName, ParseField.CommonFields.FIELD);
        parser.declareField(Builder::setMissing, XContentParser::objectText, ParseField.CommonFields.MISSING, ObjectParser.ValueType.VALUE);
        if (scriptable.booleanValue()) {
            parser.declareField(Builder::setScript, (p, context) -> Script.parse(p), Script.SCRIPT_PARSE_FIELD, ObjectParser.ValueType.OBJECT_OR_STRING);
        }
        if (timezoneAware.booleanValue()) {
            parser.declareField(Builder::setTimeZone, p -> {
                if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                    return ZoneId.of(p.text());
                }
                return ZoneOffset.ofHours(p.intValue());
            }, ParseField.CommonFields.TIME_ZONE, ObjectParser.ValueType.LONG);
        }
        return parser;
    };

    private MultiValuesSourceFieldConfig(String fieldName, Object missing, Script script, ZoneId timeZone) {
        this.fieldName = fieldName;
        this.missing = missing;
        this.script = script;
        this.timeZone = timeZone;
    }

    public MultiValuesSourceFieldConfig(StreamInput in) throws IOException {
        this.fieldName = in.readString();
        this.missing = in.readGenericValue();
        this.script = in.readOptionalWriteable(Script::new);
        this.timeZone = in.getVersion().before(Version.V_7_0_0) ? DateUtils.dateTimeZoneToZoneId(in.readOptionalTimeZone()) : in.readOptionalZoneId();
    }

    public Object getMissing() {
        return this.missing;
    }

    public Script getScript() {
        return this.script;
    }

    public ZoneId getTimeZone() {
        return this.timeZone;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.fieldName);
        out.writeGenericValue(this.missing);
        out.writeOptionalWriteable(this.script);
        if (out.getVersion().before(Version.V_7_0_0)) {
            out.writeOptionalTimeZone(DateUtils.zoneIdToDateTimeZone(this.timeZone));
        } else {
            out.writeOptionalZoneId(this.timeZone);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.missing != null) {
            builder.field(ParseField.CommonFields.MISSING.getPreferredName(), this.missing);
        }
        if (this.script != null) {
            builder.field(Script.SCRIPT_PARSE_FIELD.getPreferredName(), this.script);
        }
        if (this.fieldName != null) {
            builder.field(ParseField.CommonFields.FIELD.getPreferredName(), this.fieldName);
        }
        if (this.timeZone != null) {
            builder.field(ParseField.CommonFields.TIME_ZONE.getPreferredName(), this.timeZone.getId());
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiValuesSourceFieldConfig that = (MultiValuesSourceFieldConfig)o;
        return Objects.equals(this.fieldName, that.fieldName) && Objects.equals(this.missing, that.missing) && Objects.equals(this.script, that.script) && Objects.equals(this.timeZone, that.timeZone);
    }

    public int hashCode() {
        return Objects.hash(this.fieldName, this.missing, this.script, this.timeZone);
    }

    public String toString() {
        return Strings.toString(this);
    }

    public static class Builder {
        private String fieldName;
        private Object missing = null;
        private Script script = null;
        private ZoneId timeZone = null;

        public String getFieldName() {
            return this.fieldName;
        }

        public Builder setFieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public Object getMissing() {
            return this.missing;
        }

        public Builder setMissing(Object missing) {
            this.missing = missing;
            return this;
        }

        public Script getScript() {
            return this.script;
        }

        public Builder setScript(Script script) {
            this.script = script;
            return this;
        }

        public ZoneId getTimeZone() {
            return this.timeZone;
        }

        public Builder setTimeZone(ZoneId timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        public MultiValuesSourceFieldConfig build() {
            if (Strings.isNullOrEmpty(this.fieldName) && this.script == null) {
                throw new IllegalArgumentException("[" + ParseField.CommonFields.FIELD.getPreferredName() + "] and [" + Script.SCRIPT_PARSE_FIELD.getPreferredName() + "] cannot both be null.  Please specify one or the other.");
            }
            if (!Strings.isNullOrEmpty(this.fieldName) && this.script != null) {
                throw new IllegalArgumentException("[" + ParseField.CommonFields.FIELD.getPreferredName() + "] and [" + Script.SCRIPT_PARSE_FIELD.getPreferredName() + "] cannot both be configured.  Please specify one or the other.");
            }
            return new MultiValuesSourceFieldConfig(this.fieldName, this.missing, this.script, this.timeZone);
        }
    }
}

