/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.support;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.Aggregator;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.HasAggregations;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.SingleBucketAggregation;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.SingleBucketAggregator;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.profile.aggregation.ProfilingAggregator;

public class AggregationPath {
    private static final String AGG_DELIM = ">";
    private final List<PathElement> pathElements;

    public static AggregationPath parse(String path) {
        String[] elements = Strings.tokenizeToStringArray(path, AGG_DELIM);
        ArrayList<PathElement> tokens = new ArrayList<PathElement>(elements.length);
        String[] tuple = new String[2];
        for (int i = 0; i < elements.length; ++i) {
            int index;
            String element = elements[i];
            if (i == elements.length - 1) {
                index = element.lastIndexOf(91);
                if (index >= 0) {
                    if (index == 0 || index > element.length() - 3) {
                        throw new AggregationExecutionException("Invalid path element [" + element + "] in path [" + path + "]");
                    }
                    if (element.charAt(element.length() - 1) != ']') {
                        throw new AggregationExecutionException("Invalid path element [" + element + "] in path [" + path + "]");
                    }
                    tokens.add(new PathElement(element, element.substring(0, index), element.substring(index + 1, element.length() - 1)));
                    continue;
                }
                index = element.lastIndexOf(46);
                if (index < 0) {
                    tokens.add(new PathElement(element, element, null));
                    continue;
                }
                if (index == 0 || index > element.length() - 2) {
                    throw new AggregationExecutionException("Invalid path element [" + element + "] in path [" + path + "]");
                }
                tuple = AggregationPath.split(element, index, tuple);
                tokens.add(new PathElement(element, tuple[0], tuple[1]));
                continue;
            }
            index = element.lastIndexOf(91);
            if (index >= 0) {
                if (index == 0 || index > element.length() - 3) {
                    throw new AggregationExecutionException("Invalid path element [" + element + "] in path [" + path + "]");
                }
                if (element.charAt(element.length() - 1) != ']') {
                    throw new AggregationExecutionException("Invalid path element [" + element + "] in path [" + path + "]");
                }
                tokens.add(new PathElement(element, element.substring(0, index), element.substring(index + 1, element.length() - 1)));
                continue;
            }
            tokens.add(new PathElement(element, element, null));
        }
        return new AggregationPath(tokens);
    }

    public AggregationPath(List<PathElement> tokens) {
        this.pathElements = tokens;
        if (tokens == null || tokens.size() == 0) {
            throw new IllegalArgumentException("Invalid path [" + this + "]");
        }
    }

    public String toString() {
        return Strings.arrayToDelimitedString(this.pathElements.toArray(), AGG_DELIM);
    }

    public PathElement lastPathElement() {
        return this.pathElements.get(this.pathElements.size() - 1);
    }

    public List<PathElement> getPathElements() {
        return this.pathElements;
    }

    public List<String> getPathElementsAsStringList() {
        ArrayList<String> stringPathElements = new ArrayList<String>();
        for (PathElement pathElement : this.pathElements) {
            stringPathElements.add(pathElement.name);
            if (pathElement.key == null) continue;
            stringPathElements.add(pathElement.key);
        }
        return stringPathElements;
    }

    public AggregationPath subPath(int offset, int length) {
        ArrayList<PathElement> subTokens = new ArrayList<PathElement>(this.pathElements.subList(offset, offset + length));
        return new AggregationPath(subTokens);
    }

    public double resolveValue(HasAggregations root) {
        HasAggregations parent = root;
        double value = Double.NaN;
        for (int i = 0; i < this.pathElements.size(); ++i) {
            PathElement token = this.pathElements.get(i);
            Object agg = parent.getAggregations().get(token.name);
            if (agg == null) {
                throw new IllegalArgumentException("Invalid order path [" + this + "]. Cannot find aggregation named [" + token.name + "]");
            }
            if (agg instanceof SingleBucketAggregation) {
                if (token.key != null && !token.key.equals("doc_count")) {
                    throw new IllegalArgumentException("Invalid order path [" + this + "]. Unknown value key [" + token.key + "] for single-bucket aggregation [" + token.name + "]. Either use [doc_count] as key or drop the key all together");
                }
                parent = (SingleBucketAggregation)agg;
                value = ((SingleBucketAggregation)agg).getDocCount();
                continue;
            }
            if (i != this.pathElements.size() - 1) {
                throw new IllegalArgumentException("Invalid order path [" + this + "]. Metrics aggregations cannot have sub-aggregations (at [" + token + AGG_DELIM + this.pathElements.get(i + 1) + "]");
            }
            if (agg instanceof InternalNumericMetricsAggregation.SingleValue) {
                if (token.key != null && !token.key.equals("value")) {
                    throw new IllegalArgumentException("Invalid order path [" + this + "]. Unknown value key [" + token.key + "] for single-value metric aggregation [" + token.name + "]. Either use [value] as key or drop the key all together");
                }
                parent = null;
                value = ((InternalNumericMetricsAggregation.SingleValue)agg).value();
                continue;
            }
            if (token.key == null) {
                throw new IllegalArgumentException("Invalid order path [" + this + "]. Missing value key in [" + token + "] which refers to a multi-value metric aggregation");
            }
            parent = null;
            value = ((InternalNumericMetricsAggregation.MultiValue)agg).value(token.key);
        }
        return value;
    }

    public Aggregator resolveAggregator(Aggregator root) {
        Aggregator aggregator = root;
        for (int i = 0; i < this.pathElements.size(); ++i) {
            PathElement token = this.pathElements.get(i);
            aggregator = ProfilingAggregator.unwrap(aggregator.subAggregator(token.name));
            assert (aggregator instanceof SingleBucketAggregator && i <= this.pathElements.size() - 1 || aggregator instanceof NumericMetricsAggregator && i == this.pathElements.size() - 1) : "this should be picked up before aggregation execution - on validate";
        }
        return aggregator;
    }

    public Aggregator resolveTopmostAggregator(Aggregator root) {
        PathElement token = this.pathElements.get(0);
        Aggregator aggregator = ProfilingAggregator.unwrap(root.subAggregator(token.name));
        assert (aggregator instanceof SingleBucketAggregator || aggregator instanceof NumericMetricsAggregator) : "this should be picked up before aggregation execution - on validate";
        return aggregator;
    }

    public void validate(Aggregator root) throws AggregationExecutionException {
        Aggregator aggregator = root;
        for (int i = 0; i < this.pathElements.size(); ++i) {
            String name = this.pathElements.get((int)i).name;
            if ((aggregator = ProfilingAggregator.unwrap(aggregator.subAggregator(name))) == null) {
                throw new AggregationExecutionException("Invalid aggregator order path [" + this + "]. The provided aggregation [" + name + "] either does not exist, or is a pipeline aggregation and cannot be used to sort the buckets.");
            }
            if (i >= this.pathElements.size() - 1) continue;
            if (!(aggregator instanceof SingleBucketAggregator)) {
                throw new AggregationExecutionException("Invalid aggregation order path [" + this + "]. Buckets can only be sorted on a sub-aggregator path that is built out of zero or more single-bucket aggregations within the path and a final single-bucket or a metrics aggregation at the path end. Sub-path [" + this.subPath(0, i + 1) + "] points to non single-bucket aggregation");
            }
            if (this.pathElements.get((int)i).key == null) continue;
            throw new AggregationExecutionException("Invalid aggregation order path [" + this + "]. Buckets can only be sorted on a sub-aggregator path that is built out of zero or more single-bucket aggregations within the path and a final single-bucket or a metrics aggregation at the path end. Sub-path [" + this.subPath(0, i + 1) + "] points to non single-bucket aggregation");
        }
        boolean singleBucket = aggregator instanceof SingleBucketAggregator;
        if (!singleBucket && !(aggregator instanceof NumericMetricsAggregator)) {
            throw new AggregationExecutionException("Invalid aggregation order path [" + this + "]. Buckets can only be sorted on a sub-aggregator path that is built out of zero or more single-bucket aggregations within the path and a final single-bucket or a metrics aggregation at the path end.");
        }
        PathElement lastToken = this.lastPathElement();
        if (singleBucket) {
            if (lastToken.key != null && !"doc_count".equals(lastToken.key)) {
                throw new AggregationExecutionException("Invalid aggregation order path [" + this + "]. Ordering on a single-bucket aggregation can only be done on its doc_count. Either drop the key (a la \"" + lastToken.name + "\") or change it to \"doc_count\" (a la \"" + lastToken.name + ".doc_count\")");
            }
            return;
        }
        if (aggregator instanceof NumericMetricsAggregator.SingleValue) {
            if (lastToken.key != null && !"value".equals(lastToken.key)) {
                throw new AggregationExecutionException("Invalid aggregation order path [" + this + "]. Ordering on a single-value metrics aggregation can only be done on its value. Either drop the key (a la \"" + lastToken.name + "\") or change it to \"value\" (a la \"" + lastToken.name + ".value\")");
            }
            return;
        }
        if (lastToken.key == null) {
            throw new AggregationExecutionException("Invalid aggregation order path [" + this + "]. When ordering on a multi-value metrics aggregation a metric name must be specified");
        }
        if (!((NumericMetricsAggregator.MultiValue)aggregator).hasMetric(lastToken.key)) {
            throw new AggregationExecutionException("Invalid aggregation order path [" + this + "]. Unknown metric name [" + lastToken.key + "] on multi-value metrics aggregation [" + lastToken.name + "]");
        }
    }

    private static String[] split(String toSplit, int index, String[] result) {
        result[0] = toSplit.substring(0, index);
        result[1] = toSplit.substring(index + 1);
        return result;
    }

    public static class PathElement {
        private final String fullName;
        public final String name;
        public final String key;

        public PathElement(String fullName, String name, String key) {
            this.fullName = fullName;
            this.name = name;
            this.key = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PathElement token = (PathElement)o;
            if (this.key != null ? !this.key.equals(token.key) : token.key != null) {
                return false;
            }
            return this.name.equals(token.name);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
            return result;
        }

        public String toString() {
            return this.fullName;
        }
    }
}

