/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.pipeline;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.DocValueFormat;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.InternalAggregation;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.pipeline.BucketHelpers;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.pipeline.BucketMetricsPipelineAggregator;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.pipeline.InternalStatsBucket;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public class StatsBucketPipelineAggregator
extends BucketMetricsPipelineAggregator {
    private double sum = 0.0;
    private long count = 0L;
    private double min = Double.POSITIVE_INFINITY;
    private double max = Double.NEGATIVE_INFINITY;

    StatsBucketPipelineAggregator(String name, String[] bucketsPaths, BucketHelpers.GapPolicy gapPolicy, DocValueFormat formatter, Map<String, Object> metaData) {
        super(name, bucketsPaths, gapPolicy, formatter, metaData);
    }

    public StatsBucketPipelineAggregator(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public String getWriteableName() {
        return "stats_bucket";
    }

    @Override
    protected void preCollection() {
        this.sum = 0.0;
        this.count = 0L;
        this.min = Double.POSITIVE_INFINITY;
        this.max = Double.NEGATIVE_INFINITY;
    }

    @Override
    protected void collectBucketValue(String bucketKey, Double bucketValue) {
        this.sum += bucketValue.doubleValue();
        this.min = Math.min(this.min, bucketValue);
        this.max = Math.max(this.max, bucketValue);
        ++this.count;
    }

    @Override
    protected InternalAggregation buildAggregation(List<PipelineAggregator> pipelineAggregators, Map<String, Object> metadata) {
        return new InternalStatsBucket(this.name(), this.count, this.sum, this.min, this.max, this.format, pipelineAggregators, metadata);
    }
}

