/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.geogrid;

import java.io.IOException;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.SortedNumericDocValues;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.geo.GeoPoint;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.AbstractSortingNumericDocValues;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.MultiGeoPointValues;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.support.ValuesSource;

public class CellIdSource
extends ValuesSource.Numeric {
    private final ValuesSource.GeoPoint valuesSource;
    private final int precision;
    private final GeoPointLongEncoder encoder;

    public CellIdSource(ValuesSource.GeoPoint valuesSource, int precision, GeoPointLongEncoder encoder) {
        this.valuesSource = valuesSource;
        this.precision = precision;
        this.encoder = encoder;
    }

    public int precision() {
        return this.precision;
    }

    @Override
    public boolean isFloatingPoint() {
        return false;
    }

    @Override
    public SortedNumericDocValues longValues(LeafReaderContext ctx) {
        return new CellValues(this.valuesSource.geoPointValues(ctx), this.precision, this.encoder);
    }

    @Override
    public SortedNumericDoubleValues doubleValues(LeafReaderContext ctx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SortedBinaryDocValues bytesValues(LeafReaderContext ctx) {
        throw new UnsupportedOperationException();
    }

    private static class CellValues
    extends AbstractSortingNumericDocValues {
        private MultiGeoPointValues geoValues;
        private int precision;
        private GeoPointLongEncoder encoder;

        protected CellValues(MultiGeoPointValues geoValues, int precision, GeoPointLongEncoder encoder) {
            this.geoValues = geoValues;
            this.precision = precision;
            this.encoder = encoder;
        }

        @Override
        public boolean advanceExact(int docId) throws IOException {
            if (this.geoValues.advanceExact(docId)) {
                this.resize(this.geoValues.docValueCount());
                for (int i = 0; i < this.docValueCount(); ++i) {
                    GeoPoint target = this.geoValues.nextValue();
                    this.values[i] = this.encoder.encode(target.getLon(), target.getLat(), this.precision);
                }
                this.sort();
                return true;
            }
            return false;
        }
    }

    @FunctionalInterface
    public static interface GeoPointLongEncoder {
        public long encode(double var1, double var3, int var5);
    }
}

