/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.action.search;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.cluster.node.tasks.cancel.CancelTasksRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.cluster.node.tasks.cancel.CancelTasksResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.ContextPreservingActionListener;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.Client;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.node.NodeClient;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.util.concurrent.ThreadContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.http.HttpChannel;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.tasks.Task;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.tasks.TaskId;

public final class HttpChannelTaskHandler {
    public static final HttpChannelTaskHandler INSTANCE = new HttpChannelTaskHandler();
    final Map<HttpChannel, CloseListener> httpChannels = new ConcurrentHashMap<HttpChannel, CloseListener>();

    private HttpChannelTaskHandler() {
    }

    <Response extends ActionResponse> void execute(NodeClient client, HttpChannel httpChannel, ActionRequest request, ActionType<Response> actionType, final ActionListener<Response> listener) {
        final CloseListener closeListener = this.httpChannels.computeIfAbsent(httpChannel, channel -> new CloseListener(client));
        final TaskHolder taskHolder = new TaskHolder();
        Task task = client.executeLocally(actionType, request, new ActionListener<Response>(){

            @Override
            public void onResponse(Response searchResponse) {
                try {
                    closeListener.unregisterTask(taskHolder);
                }
                finally {
                    listener.onResponse(searchResponse);
                }
            }

            @Override
            public void onFailure(Exception e) {
                try {
                    closeListener.unregisterTask(taskHolder);
                }
                finally {
                    listener.onFailure(e);
                }
            }
        });
        closeListener.registerTask(taskHolder, new TaskId(client.getLocalNodeId(), task.getId()));
        closeListener.maybeRegisterChannel(httpChannel);
    }

    public int getNumChannels() {
        return this.httpChannels.size();
    }

    private static class TaskHolder {
        private TaskId taskId;
        private boolean completed = false;

        private TaskHolder() {
        }
    }

    final class CloseListener
    implements ActionListener<Void> {
        private final Client client;
        private final AtomicReference<HttpChannel> channel = new AtomicReference();
        private final Set<TaskId> taskIds = new HashSet<TaskId>();

        CloseListener(Client client) {
            this.client = client;
        }

        int getNumTasks() {
            return this.taskIds.size();
        }

        void maybeRegisterChannel(HttpChannel httpChannel) {
            if (this.channel.compareAndSet(null, httpChannel)) {
                httpChannel.addCloseListener(this);
            }
        }

        synchronized void registerTask(TaskHolder taskHolder, TaskId taskId) {
            taskHolder.taskId = taskId;
            if (!taskHolder.completed) {
                this.taskIds.add(taskId);
            }
        }

        synchronized void unregisterTask(TaskHolder taskHolder) {
            if (taskHolder.taskId != null) {
                this.taskIds.remove(taskHolder.taskId);
            }
            taskHolder.completed = true;
        }

        @Override
        public synchronized void onResponse(Void aVoid) {
            CloseListener closeListener = HttpChannelTaskHandler.this.httpChannels.remove(this.channel.get());
            assert (closeListener != null) : "channel not found in the map of tracked channels";
            for (TaskId taskId : this.taskIds) {
                ThreadContext threadContext = this.client.threadPool().getThreadContext();
                ThreadContext.StoredContext ignore = threadContext.stashContext();
                try {
                    threadContext.markAsSystemContext();
                    ContextPreservingActionListener<CancelTasksResponse> contextPreservingListener = new ContextPreservingActionListener<CancelTasksResponse>(threadContext.newRestorableContext(false), ActionListener.wrap(r -> {}, e -> {}));
                    CancelTasksRequest cancelTasksRequest = new CancelTasksRequest();
                    cancelTasksRequest.setTaskId(taskId);
                    this.client.admin().cluster().cancelTasks(cancelTasksRequest, contextPreservingListener);
                }
                finally {
                    if (ignore == null) continue;
                    ignore.close();
                }
            }
        }

        @Override
        public void onFailure(Exception e) {
            this.onResponse(null);
        }
    }
}

