/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.Map;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.IndicesOptions;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.Requests;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.node.NodeClient;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.logging.DeprecationLogger;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentHelper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MapperService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.BaseRestHandler;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestChannel;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestController;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.action.RestToXContentListener;
import org.apache.logging.log4j.LogManager;

public class RestPutMappingAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(RestPutMappingAction.class));
    public static final String TYPES_DEPRECATION_MESSAGE = "[types removal] Using include_type_name in put mapping requests is deprecated. The parameter will be removed in the next major version.";

    public RestPutMappingAction(RestController controller) {
        controller.registerHandler(RestRequest.Method.PUT, "/{index}/_mapping/", this);
        controller.registerHandler(RestRequest.Method.PUT, "/{index}/{type}/_mapping", this);
        controller.registerHandler(RestRequest.Method.PUT, "/{index}/_mapping/{type}", this);
        controller.registerHandler(RestRequest.Method.PUT, "/_mapping/{type}", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_mapping/", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_mapping", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_mapping/{type}", this);
        controller.registerHandler(RestRequest.Method.POST, "/_mapping/{type}", this);
        controller.registerHandler(RestRequest.Method.PUT, "/{index}/_mappings/", this);
        controller.registerHandler(RestRequest.Method.PUT, "/{index}/{type}/_mappings", this);
        controller.registerHandler(RestRequest.Method.PUT, "/{index}/_mappings/{type}", this);
        controller.registerHandler(RestRequest.Method.PUT, "/_mappings/{type}", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_mappings/", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_mappings", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_mappings/{type}", this);
        controller.registerHandler(RestRequest.Method.POST, "/_mappings/{type}", this);
    }

    @Override
    public String getName() {
        return "put_mapping_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        boolean includeTypeName = request.paramAsBoolean("include_type_name", false);
        if (request.hasParam("include_type_name")) {
            deprecationLogger.deprecatedAndMaybeLog("put_mapping_with_types", TYPES_DEPRECATION_MESSAGE, new Object[0]);
        }
        PutMappingRequest putMappingRequest = Requests.putMappingRequest(Strings.splitStringByCommaToArray(request.param("index")));
        String type = request.param("type");
        putMappingRequest.type(includeTypeName ? type : "_doc");
        Map<String, Object> sourceAsMap = XContentHelper.convertToMap(request.requiredContent(), false, request.getXContentType()).v2();
        if (!includeTypeName && (type != null || MapperService.isMappingSourceTyped("_doc", sourceAsMap))) {
            throw new IllegalArgumentException("Types cannot be provided in put mapping requests, unless the include_type_name parameter is set to true.");
        }
        putMappingRequest.source(sourceAsMap);
        putMappingRequest.timeout(request.paramAsTime("timeout", putMappingRequest.timeout()));
        putMappingRequest.masterNodeTimeout(request.paramAsTime("master_timeout", putMappingRequest.masterNodeTimeout()));
        putMappingRequest.indicesOptions(IndicesOptions.fromRequest(request, putMappingRequest.indicesOptions()));
        return channel -> client.admin().indices().putMapping(putMappingRequest, new RestToXContentListener<AcknowledgedResponse>((RestChannel)channel));
    }
}

