/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.action.admin.indices;

import java.io.IOException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.segments.IndicesSegmentResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.segments.IndicesSegmentsRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.IndicesOptions;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.node.NodeClient;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.BaseRestHandler;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestChannel;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestController;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.action.RestToXContentListener;

public class RestIndicesSegmentsAction
extends BaseRestHandler {
    public RestIndicesSegmentsAction(RestController controller) {
        controller.registerHandler(RestRequest.Method.GET, "/_segments", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_segments", this);
    }

    @Override
    public String getName() {
        return "indices_segments_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        IndicesSegmentsRequest indicesSegmentsRequest = new IndicesSegmentsRequest(Strings.splitStringByCommaToArray(request.param("index")));
        indicesSegmentsRequest.verbose(request.paramAsBoolean("verbose", false));
        indicesSegmentsRequest.indicesOptions(IndicesOptions.fromRequest(request, indicesSegmentsRequest.indicesOptions()));
        return channel -> client.admin().indices().segments(indicesSegmentsRequest, new RestToXContentListener<IndicesSegmentResponse>((RestChannel)channel));
    }
}

