/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.warmer;

import java.util.concurrent.TimeUnit;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.metrics.CounterMetric;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.metrics.MeanMetric;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.IndexSettings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.shard.ShardId;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.warmer.WarmerStats;
import org.apache.logging.log4j.Logger;

public class ShardIndexWarmerService
extends AbstractIndexShardComponent {
    private final CounterMetric current = new CounterMetric();
    private final MeanMetric warmerMetric = new MeanMetric();

    public ShardIndexWarmerService(ShardId shardId, IndexSettings indexSettings) {
        super(shardId, indexSettings);
    }

    public Logger logger() {
        return this.logger;
    }

    public void onPreWarm() {
        this.current.inc();
    }

    public void onPostWarm(long tookInNanos) {
        this.current.dec();
        this.warmerMetric.inc(tookInNanos);
    }

    public WarmerStats stats() {
        return new WarmerStats(this.current.count(), this.warmerMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.warmerMetric.sum()));
    }
}

