/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.rankeval;

import java.io.IOException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.IndicesOptions;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.node.NodeClient;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.rankeval.RankEvalAction;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.rankeval.RankEvalRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.rankeval.RankEvalSpec;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.BaseRestHandler;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestChannel;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestController;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.action.RestToXContentListener;

public class RestRankEvalAction
extends BaseRestHandler {
    public static String ENDPOINT = "_rank_eval";

    public RestRankEvalAction(RestController controller) {
        controller.registerHandler(RestRequest.Method.GET, "/" + ENDPOINT, this);
        controller.registerHandler(RestRequest.Method.POST, "/" + ENDPOINT, this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/" + ENDPOINT, this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/" + ENDPOINT, this);
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        RankEvalRequest rankEvalRequest = new RankEvalRequest();
        try (XContentParser parser = request.contentOrSourceParamParser();){
            RestRankEvalAction.parseRankEvalRequest(rankEvalRequest, request, parser);
        }
        return channel -> client.executeLocally(RankEvalAction.INSTANCE, rankEvalRequest, new RestToXContentListener((RestChannel)channel));
    }

    private static void parseRankEvalRequest(RankEvalRequest rankEvalRequest, RestRequest request, XContentParser parser) {
        rankEvalRequest.indices(Strings.splitStringByCommaToArray(request.param("index")));
        rankEvalRequest.indicesOptions(IndicesOptions.fromRequest(request, rankEvalRequest.indicesOptions()));
        RankEvalSpec spec = RankEvalSpec.parse(parser);
        rankEvalRequest.setRankEvalSpec(spec);
    }

    @Override
    public String getName() {
        return "rank_eval_action";
    }
}

