/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.IndexOptions;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.IndexableField;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Query;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MappedFieldType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.Mapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MapperParsingException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.ParseContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.StringFieldType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.QueryShardContext;

public class AllFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_all";
    public static final String CONTENT_TYPE = "_all";
    private final boolean disableExplicit;

    private AllFieldMapper(Settings indexSettings, MappedFieldType existing, boolean disableExplicit) {
        this(existing.clone(), indexSettings, disableExplicit);
    }

    private AllFieldMapper(MappedFieldType fieldType, Settings indexSettings, boolean disableExplicit) {
        super("_all", fieldType, Defaults.FIELD_TYPE, indexSettings);
        this.disableExplicit = disableExplicit;
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
    }

    @Override
    public void postParse(ParseContext context) throws IOException {
        super.parse(context);
    }

    @Override
    public void parse(ParseContext context) throws IOException {
    }

    @Override
    protected void parseCreateField(ParseContext context, List<IndexableField> fields) throws IOException {
    }

    @Override
    protected String contentType() {
        return "_all";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean includeDefaults = params.paramAsBoolean("include_defaults", false);
        if (includeDefaults || this.disableExplicit) {
            builder.startObject("_all");
            if (this.disableExplicit) {
                builder.field("enabled", false);
            }
            builder.endObject();
        }
        return builder;
    }

    static final class AllFieldType
    extends StringFieldType {
        AllFieldType() {
        }

        protected AllFieldType(AllFieldType ref) {
            super(ref);
        }

        @Override
        public MappedFieldType clone() {
            return new AllFieldType(this);
        }

        @Override
        public String typeName() {
            return "_all";
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            return new MatchNoDocsQuery();
        }
    }

    public static class TypeParser
    implements MetadataFieldMapper.TypeParser {
        @Override
        public MetadataFieldMapper.Builder<?, ?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(parserContext.mapperService().fullName("_all"));
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String fieldName = entry.getKey();
                if (!fieldName.equals("enabled")) continue;
                boolean enabled = XContentMapValues.nodeBooleanValue(entry.getValue(), "enabled");
                if (enabled) {
                    throw new IllegalArgumentException("[_all] is disabled in this version.");
                }
                builder.setDisableExplicit();
                iterator.remove();
            }
            return builder;
        }

        @Override
        public MetadataFieldMapper getDefault(MappedFieldType fieldType, Mapper.TypeParser.ParserContext context) {
            Settings indexSettings = context.mapperService().getIndexSettings().getSettings();
            return new AllFieldMapper(indexSettings, Defaults.FIELD_TYPE, false);
        }
    }

    public static class Builder
    extends MetadataFieldMapper.Builder<Builder, AllFieldMapper> {
        private boolean disableExplicit = false;

        public Builder(MappedFieldType existing) {
            super("_all", existing == null ? Defaults.FIELD_TYPE : existing, Defaults.FIELD_TYPE);
            this.builder = this;
        }

        private Builder setDisableExplicit() {
            this.disableExplicit = true;
            return this;
        }

        @Override
        public AllFieldMapper build(Mapper.BuilderContext context) {
            return new AllFieldMapper(this.fieldType, context.indexSettings(), this.disableExplicit);
        }
    }

    public static class Defaults {
        public static final MappedFieldType FIELD_TYPE = new AllFieldType();

        static {
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
            FIELD_TYPE.setTokenized(true);
            FIELD_TYPE.setName("_all");
            FIELD_TYPE.freeze();
        }
    }
}

