/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.plain;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.function.LongUnaryOperator;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document.HalfFloatPoint;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.DocValues;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.LeafReader;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.NumericDocValues;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.SortedNumericDocValues;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.SortField;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.SortedNumericSelector;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.SortedNumericSortField;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.Accountable;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.NumericUtils;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.time.DateUtils;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.Index;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.AbstractSortedNumericDocValues;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.FieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.IndexFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.NumericDoubleValues;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.fieldcomparator.DoubleValuesComparatorSource;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.fieldcomparator.FloatValuesComparatorSource;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.fieldcomparator.LongValuesComparatorSource;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.plain.AtomicDoubleFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.plain.AtomicLongFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.plain.DocValuesIndexFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.MultiValueMode;

public class SortedNumericDVIndexFieldData
extends DocValuesIndexFieldData
implements IndexNumericFieldData {
    private final IndexNumericFieldData.NumericType numericType;

    public SortedNumericDVIndexFieldData(Index index, String fieldNames, IndexNumericFieldData.NumericType numericType) {
        super(index, fieldNames);
        if (numericType == null) {
            throw new IllegalArgumentException("numericType must be non-null");
        }
        this.numericType = numericType;
    }

    public SortField sortField(IndexNumericFieldData.NumericType targetNumericType, Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, boolean reverse) {
        SortedNumericSortField sortField;
        IndexFieldData.XFieldComparatorSource source;
        switch (targetNumericType) {
            case HALF_FLOAT: 
            case FLOAT: {
                source = new FloatValuesComparatorSource(this, missingValue, sortMode, nested);
                break;
            }
            case DOUBLE: {
                source = new DoubleValuesComparatorSource(this, missingValue, sortMode, nested);
                break;
            }
            case DATE: {
                if (this.numericType == IndexNumericFieldData.NumericType.DATE_NANOSECONDS) {
                    source = new LongValuesComparatorSource(this, missingValue, sortMode, nested, dvs -> SortedNumericDVIndexFieldData.convertNanosToMillis(dvs));
                    break;
                }
                source = new LongValuesComparatorSource(this, missingValue, sortMode, nested);
                break;
            }
            case DATE_NANOSECONDS: {
                if (this.numericType == IndexNumericFieldData.NumericType.DATE) {
                    source = new LongValuesComparatorSource(this, missingValue, sortMode, nested, dvs -> SortedNumericDVIndexFieldData.convertMillisToNanos(dvs));
                    break;
                }
                source = new LongValuesComparatorSource(this, missingValue, sortMode, nested);
                break;
            }
            default: {
                assert (!targetNumericType.isFloatingPoint());
                source = new LongValuesComparatorSource(this, missingValue, sortMode, nested);
            }
        }
        if (nested != null || sortMode != MultiValueMode.MAX && sortMode != MultiValueMode.MIN || this.numericType == IndexNumericFieldData.NumericType.HALF_FLOAT || targetNumericType != this.numericType) {
            return new SortField(this.fieldName, source, reverse);
        }
        SortedNumericSelector.Type selectorType = sortMode == MultiValueMode.MAX ? SortedNumericSelector.Type.MAX : SortedNumericSelector.Type.MIN;
        switch (this.numericType) {
            case FLOAT: {
                sortField = new SortedNumericSortField(this.fieldName, SortField.Type.FLOAT, reverse, selectorType);
                break;
            }
            case DOUBLE: {
                sortField = new SortedNumericSortField(this.fieldName, SortField.Type.DOUBLE, reverse, selectorType);
                break;
            }
            default: {
                assert (!this.numericType.isFloatingPoint());
                sortField = new SortedNumericSortField(this.fieldName, SortField.Type.LONG, reverse, selectorType);
            }
        }
        ((SortField)sortField).setMissingValue(source.missingObject(missingValue, reverse));
        return sortField;
    }

    @Override
    public SortField sortField(Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, boolean reverse) {
        return this.sortField(this.numericType, missingValue, sortMode, nested, reverse);
    }

    @Override
    public IndexNumericFieldData.NumericType getNumericType() {
        return this.numericType;
    }

    @Override
    public AtomicNumericFieldData loadDirect(LeafReaderContext context) throws Exception {
        return this.load(context);
    }

    @Override
    public AtomicNumericFieldData load(LeafReaderContext context) {
        LeafReader reader = context.reader();
        String field = this.fieldName;
        switch (this.numericType) {
            case HALF_FLOAT: {
                return new SortedNumericHalfFloatFieldData(reader, field);
            }
            case FLOAT: {
                return new SortedNumericFloatFieldData(reader, field);
            }
            case DOUBLE: {
                return new SortedNumericDoubleFieldData(reader, field);
            }
            case DATE_NANOSECONDS: {
                return new NanoSecondFieldData(reader, field, this.numericType);
            }
        }
        return new SortedNumericLongFieldData(reader, field, this.numericType);
    }

    static SortedNumericDocValues convertNanosToMillis(SortedNumericDocValues dvs) {
        return SortedNumericDVIndexFieldData.convertNumeric(dvs, DateUtils::toMilliSeconds);
    }

    static SortedNumericDocValues convertMillisToNanos(SortedNumericDocValues values) {
        return SortedNumericDVIndexFieldData.convertNumeric(values, DateUtils::toNanoSeconds);
    }

    private static SortedNumericDocValues convertNumeric(final SortedNumericDocValues values, final LongUnaryOperator converter) {
        return new AbstractSortedNumericDocValues(){

            @Override
            public boolean advanceExact(int target) throws IOException {
                return values.advanceExact(target);
            }

            @Override
            public long nextValue() throws IOException {
                return converter.applyAsLong(values.nextValue());
            }

            @Override
            public int docValueCount() {
                return values.docValueCount();
            }

            @Override
            public int nextDoc() throws IOException {
                return values.nextDoc();
            }
        };
    }

    static final class SortedNumericDoubleFieldData
    extends AtomicDoubleFieldData {
        final LeafReader reader;
        final String field;

        SortedNumericDoubleFieldData(LeafReader reader, String field) {
            super(0L);
            this.reader = reader;
            this.field = field;
        }

        @Override
        public SortedNumericDoubleValues getDoubleValues() {
            try {
                SortedNumericDocValues raw = DocValues.getSortedNumeric(this.reader, this.field);
                return FieldData.sortableLongBitsToDoubles(raw);
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot load doc values", e);
            }
        }

        @Override
        public Collection<Accountable> getChildResources() {
            return Collections.emptyList();
        }
    }

    static final class MultiFloatValues
    extends SortedNumericDoubleValues {
        final SortedNumericDocValues in;

        MultiFloatValues(SortedNumericDocValues in) {
            this.in = in;
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            return this.in.advanceExact(target);
        }

        @Override
        public double nextValue() throws IOException {
            return NumericUtils.sortableIntToFloat((int)this.in.nextValue());
        }

        @Override
        public int docValueCount() {
            return this.in.docValueCount();
        }
    }

    static final class SingleFloatValues
    extends NumericDoubleValues {
        final NumericDocValues in;

        SingleFloatValues(NumericDocValues in) {
            this.in = in;
        }

        @Override
        public double doubleValue() throws IOException {
            return NumericUtils.sortableIntToFloat((int)this.in.longValue());
        }

        @Override
        public boolean advanceExact(int doc) throws IOException {
            return this.in.advanceExact(doc);
        }
    }

    static final class SortedNumericFloatFieldData
    extends AtomicDoubleFieldData {
        final LeafReader reader;
        final String field;

        SortedNumericFloatFieldData(LeafReader reader, String field) {
            super(0L);
            this.reader = reader;
            this.field = field;
        }

        @Override
        public SortedNumericDoubleValues getDoubleValues() {
            try {
                SortedNumericDocValues raw = DocValues.getSortedNumeric(this.reader, this.field);
                NumericDocValues single = DocValues.unwrapSingleton(raw);
                if (single != null) {
                    return FieldData.singleton(new SingleFloatValues(single));
                }
                return new MultiFloatValues(raw);
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot load doc values", e);
            }
        }

        @Override
        public Collection<Accountable> getChildResources() {
            return Collections.emptyList();
        }
    }

    static final class MultiHalfFloatValues
    extends SortedNumericDoubleValues {
        final SortedNumericDocValues in;

        MultiHalfFloatValues(SortedNumericDocValues in) {
            this.in = in;
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            return this.in.advanceExact(target);
        }

        @Override
        public double nextValue() throws IOException {
            return HalfFloatPoint.sortableShortToHalfFloat((short)this.in.nextValue());
        }

        @Override
        public int docValueCount() {
            return this.in.docValueCount();
        }
    }

    static final class SingleHalfFloatValues
    extends NumericDoubleValues {
        final NumericDocValues in;

        SingleHalfFloatValues(NumericDocValues in) {
            this.in = in;
        }

        @Override
        public double doubleValue() throws IOException {
            return HalfFloatPoint.sortableShortToHalfFloat((short)this.in.longValue());
        }

        @Override
        public boolean advanceExact(int doc) throws IOException {
            return this.in.advanceExact(doc);
        }
    }

    static final class SortedNumericHalfFloatFieldData
    extends AtomicDoubleFieldData {
        final LeafReader reader;
        final String field;

        SortedNumericHalfFloatFieldData(LeafReader reader, String field) {
            super(0L);
            this.reader = reader;
            this.field = field;
        }

        @Override
        public SortedNumericDoubleValues getDoubleValues() {
            try {
                SortedNumericDocValues raw = DocValues.getSortedNumeric(this.reader, this.field);
                NumericDocValues single = DocValues.unwrapSingleton(raw);
                if (single != null) {
                    return FieldData.singleton(new SingleHalfFloatValues(single));
                }
                return new MultiHalfFloatValues(raw);
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot load doc values", e);
            }
        }

        @Override
        public Collection<Accountable> getChildResources() {
            return Collections.emptyList();
        }
    }

    static final class SortedNumericLongFieldData
    extends AtomicLongFieldData {
        final LeafReader reader;
        final String field;

        SortedNumericLongFieldData(LeafReader reader, String field, IndexNumericFieldData.NumericType numericType) {
            super(0L, numericType);
            this.reader = reader;
            this.field = field;
        }

        @Override
        public SortedNumericDocValues getLongValues() {
            try {
                return DocValues.getSortedNumeric(this.reader, this.field);
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot load doc values", e);
            }
        }

        @Override
        public Collection<Accountable> getChildResources() {
            return Collections.emptyList();
        }
    }

    public final class NanoSecondFieldData
    extends AtomicLongFieldData {
        private final LeafReader reader;
        private final String fieldName;

        NanoSecondFieldData(LeafReader reader, String fieldName, IndexNumericFieldData.NumericType numericType) {
            super(0L, numericType);
            this.reader = reader;
            this.fieldName = fieldName;
        }

        @Override
        public SortedNumericDocValues getLongValues() {
            return SortedNumericDVIndexFieldData.convertNanosToMillis(this.getLongValuesAsNanos());
        }

        public SortedNumericDocValues getLongValuesAsNanos() {
            try {
                return DocValues.getSortedNumeric(this.reader, this.fieldName);
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot load doc values", e);
            }
        }
    }
}

