/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.plain;

import java.io.IOException;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.DirectoryReader;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.FilteredTermsEnum;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.LeafReader;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.OrdinalMap;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.Terms;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.TermsEnum;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ElasticsearchException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.IndexSettings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.AtomicOrdinalsFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.IndexOrdinalsFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.ordinals.GlobalOrdinalsBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.ordinals.GlobalOrdinalsIndexFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.plain.AbstractAtomicOrdinalsFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.plain.AbstractIndexFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.indices.breaker.CircuitBreakerService;

public abstract class AbstractIndexOrdinalsFieldData
extends AbstractIndexFieldData<AtomicOrdinalsFieldData>
implements IndexOrdinalsFieldData {
    private final double minFrequency;
    private final double maxFrequency;
    private final int minSegmentSize;
    protected final CircuitBreakerService breakerService;

    protected AbstractIndexOrdinalsFieldData(IndexSettings indexSettings, String fieldName, IndexFieldDataCache cache, CircuitBreakerService breakerService, double minFrequency, double maxFrequency, int minSegmentSize) {
        super(indexSettings, fieldName, cache);
        this.breakerService = breakerService;
        this.minFrequency = minFrequency;
        this.maxFrequency = maxFrequency;
        this.minSegmentSize = minSegmentSize;
    }

    @Override
    public OrdinalMap getOrdinalMap() {
        return null;
    }

    @Override
    public IndexOrdinalsFieldData loadGlobal(DirectoryReader indexReader) {
        IndexOrdinalsFieldData fieldData = this.loadGlobalInternal(indexReader);
        if (fieldData instanceof GlobalOrdinalsIndexFieldData) {
            return ((GlobalOrdinalsIndexFieldData)fieldData).newConsumer(indexReader);
        }
        return fieldData;
    }

    private IndexOrdinalsFieldData loadGlobalInternal(DirectoryReader indexReader) {
        if (indexReader.leaves().size() <= 1) {
            return this;
        }
        boolean fieldFound = false;
        for (LeafReaderContext context : indexReader.leaves()) {
            if (context.reader().getFieldInfos().fieldInfo(this.getFieldName()) == null) continue;
            fieldFound = true;
            break;
        }
        if (!fieldFound) {
            try {
                return GlobalOrdinalsBuilder.buildEmpty(this.indexSettings, indexReader, this);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            return this.cache.load(indexReader, this);
        }
        catch (Exception e) {
            if (e instanceof ElasticsearchException) {
                throw (ElasticsearchException)e;
            }
            throw new ElasticsearchException(e);
        }
    }

    @Override
    public IndexOrdinalsFieldData localGlobalDirect(DirectoryReader indexReader) throws Exception {
        return GlobalOrdinalsBuilder.build(indexReader, this, this.indexSettings, this.breakerService, this.logger, AbstractAtomicOrdinalsFieldData.DEFAULT_SCRIPT_FUNCTION);
    }

    @Override
    protected AtomicOrdinalsFieldData empty(int maxDoc) {
        return AbstractAtomicOrdinalsFieldData.empty();
    }

    protected TermsEnum filter(Terms terms, TermsEnum iterator, LeafReader reader) throws IOException {
        if (iterator == null) {
            return null;
        }
        int docCount = terms.getDocCount();
        if (docCount == -1) {
            docCount = reader.maxDoc();
        }
        if (docCount >= this.minSegmentSize) {
            int maxFreq;
            int minFreq = this.minFrequency > 1.0 ? (int)this.minFrequency : (int)((double)docCount * this.minFrequency);
            int n = maxFreq = this.maxFrequency > 1.0 ? (int)this.maxFrequency : (int)((double)docCount * this.maxFrequency);
            if (minFreq > 1 || maxFreq < docCount) {
                iterator = new FrequencyFilter(iterator, minFreq, maxFreq);
            }
        }
        return iterator;
    }

    @Override
    public boolean supportsGlobalOrdinalsMapping() {
        return false;
    }

    private static final class FrequencyFilter
    extends FilteredTermsEnum {
        private int minFreq;
        private int maxFreq;

        FrequencyFilter(TermsEnum delegate, int minFreq, int maxFreq) {
            super(delegate, false);
            this.minFreq = minFreq;
            this.maxFreq = maxFreq;
        }

        @Override
        protected FilteredTermsEnum.AcceptStatus accept(BytesRef arg0) throws IOException {
            int docFreq = this.docFreq();
            if (docFreq >= this.minFreq && docFreq <= this.maxFreq) {
                return FilteredTermsEnum.AcceptStatus.YES;
            }
            return FilteredTermsEnum.AcceptStatus.NO;
        }
    }
}

