/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.fieldcomparator;

import java.io.IOException;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.NumericDocValues;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.DocIdSetIterator;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.FieldComparator;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.SortField;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BitSet;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.FieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.IndexFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.NumericDoubleValues;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.MultiValueMode;

public class FloatValuesComparatorSource
extends IndexFieldData.XFieldComparatorSource {
    private final IndexNumericFieldData indexFieldData;

    public FloatValuesComparatorSource(IndexNumericFieldData indexFieldData, @Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested) {
        super(missingValue, sortMode, nested);
        this.indexFieldData = indexFieldData;
    }

    @Override
    public SortField.Type reducedType() {
        return SortField.Type.FLOAT;
    }

    @Override
    public FieldComparator<?> newComparator(String fieldname, int numHits, int sortPos, boolean reversed) {
        assert (this.indexFieldData == null || fieldname.equals(this.indexFieldData.getFieldName()));
        final float dMissingValue = ((Float)this.missingObject(this.missingValue, reversed)).floatValue();
        return new FieldComparator.FloatComparator(numHits, null, null){

            @Override
            protected NumericDocValues getNumericDocValues(LeafReaderContext context, String field) throws IOException {
                NumericDoubleValues selectedValues;
                SortedNumericDoubleValues values = ((AtomicNumericFieldData)FloatValuesComparatorSource.this.indexFieldData.load(context)).getDoubleValues();
                if (FloatValuesComparatorSource.this.nested == null) {
                    selectedValues = FieldData.replaceMissing(FloatValuesComparatorSource.this.sortMode.select(values), dMissingValue);
                } else {
                    BitSet rootDocs = FloatValuesComparatorSource.this.nested.rootDocs(context);
                    DocIdSetIterator innerDocs = FloatValuesComparatorSource.this.nested.innerDocs(context);
                    int maxChildren = FloatValuesComparatorSource.this.nested.getNestedSort() != null ? FloatValuesComparatorSource.this.nested.getNestedSort().getMaxChildren() : Integer.MAX_VALUE;
                    selectedValues = FloatValuesComparatorSource.this.sortMode.select(values, dMissingValue, rootDocs, innerDocs, context.reader().maxDoc(), maxChildren);
                }
                return selectedValues.getRawFloatValues();
            }
        };
    }
}

