/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.gateway;

import java.io.IOException;
import java.util.List;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionFuture;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.FailedNodeException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.ActionFilters;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.PlainActionFuture;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.nodes.BaseNodeRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.ClusterName;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.MetaData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.node.DiscoveryNode;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.service.ClusterService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.inject.Inject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.unit.TimeValue;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.gateway.GatewayMetaState;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.threadpool.ThreadPool;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportService;

public class TransportNodesListGatewayMetaState
extends TransportNodesAction<Request, NodesGatewayMetaState, NodeRequest, NodeGatewayMetaState> {
    public static final String ACTION_NAME = "internal:gateway/local/meta_state";
    public static final ActionType<NodesGatewayMetaState> TYPE = new ActionType<NodesGatewayMetaState>("internal:gateway/local/meta_state", NodesGatewayMetaState::new);
    private final GatewayMetaState metaState;

    @Inject
    public TransportNodesListGatewayMetaState(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, GatewayMetaState metaState) {
        super(ACTION_NAME, threadPool, clusterService, transportService, actionFilters, Request::new, NodeRequest::new, "generic", NodeGatewayMetaState.class);
        this.metaState = metaState;
    }

    public ActionFuture<NodesGatewayMetaState> list(String[] nodesIds, @Nullable TimeValue timeout) {
        PlainActionFuture<NodesGatewayMetaState> future = PlainActionFuture.newFuture();
        this.execute((Request)new Request(nodesIds).timeout(timeout), future);
        return future;
    }

    @Override
    protected NodeRequest newNodeRequest(Request request) {
        return new NodeRequest();
    }

    @Override
    protected NodeGatewayMetaState newNodeResponse(StreamInput in) throws IOException {
        return new NodeGatewayMetaState(in);
    }

    @Override
    protected NodesGatewayMetaState newResponse(Request request, List<NodeGatewayMetaState> responses, List<FailedNodeException> failures) {
        return new NodesGatewayMetaState(this.clusterService.getClusterName(), responses, failures);
    }

    @Override
    protected NodeGatewayMetaState nodeOperation(NodeRequest request) {
        return new NodeGatewayMetaState(this.clusterService.localNode(), this.metaState.getMetaData());
    }

    public static class NodeGatewayMetaState
    extends BaseNodeResponse {
        private MetaData metaData;

        public NodeGatewayMetaState(StreamInput in) throws IOException {
            super(in);
            if (in.readBoolean()) {
                this.metaData = MetaData.readFrom(in);
            }
        }

        public NodeGatewayMetaState(DiscoveryNode node, MetaData metaData) {
            super(node);
            this.metaData = metaData;
        }

        public MetaData metaData() {
            return this.metaData;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            if (this.metaData == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                this.metaData.writeTo(out);
            }
        }
    }

    public static class NodeRequest
    extends BaseNodeRequest {
        NodeRequest() {
        }

        NodeRequest(StreamInput in) throws IOException {
            super(in);
        }
    }

    public static class NodesGatewayMetaState
    extends BaseNodesResponse<NodeGatewayMetaState> {
        public NodesGatewayMetaState(StreamInput in) throws IOException {
            super(in);
        }

        public NodesGatewayMetaState(ClusterName clusterName, List<NodeGatewayMetaState> nodes, List<FailedNodeException> failures) {
            super(clusterName, nodes, failures);
        }

        @Override
        protected List<NodeGatewayMetaState> readNodesFrom(StreamInput in) throws IOException {
            return in.readList(NodeGatewayMetaState::new);
        }

        @Override
        protected void writeNodesTo(StreamOutput out, List<NodeGatewayMetaState> nodes) throws IOException {
            out.writeList(nodes);
        }
    }

    public static class Request
    extends BaseNodesRequest<Request> {
        public Request(StreamInput in) throws IOException {
            super(in);
        }

        public Request(String ... nodesIds) {
            super(nodesIds);
        }
    }
}

