/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.env;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.gateway.MetaDataStateFormat;

public final class NodeMetaData {
    static final String NODE_ID_KEY = "node_id";
    static final String NODE_VERSION_KEY = "node_version";
    private final String nodeId;
    private final Version nodeVersion;
    public static final MetaDataStateFormat<NodeMetaData> FORMAT = new NodeMetaDataStateFormat(false);

    public NodeMetaData(String nodeId, Version nodeVersion) {
        this.nodeId = Objects.requireNonNull(nodeId);
        this.nodeVersion = Objects.requireNonNull(nodeVersion);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeMetaData that = (NodeMetaData)o;
        return this.nodeId.equals(that.nodeId) && this.nodeVersion.equals(that.nodeVersion);
    }

    public int hashCode() {
        return Objects.hash(this.nodeId, this.nodeVersion);
    }

    public String toString() {
        return "NodeMetaData{nodeId='" + this.nodeId + '\'' + ", nodeVersion=" + this.nodeVersion + '}';
    }

    public String nodeId() {
        return this.nodeId;
    }

    public Version nodeVersion() {
        return this.nodeVersion;
    }

    public NodeMetaData upgradeToCurrentVersion() {
        if (this.nodeVersion.equals(Version.V_EMPTY)) {
            assert (Version.CURRENT.major <= Version.V_7_0_0.major + 1) : "version is required in the node metadata from v9 onwards";
            return new NodeMetaData(this.nodeId, Version.CURRENT);
        }
        if (this.nodeVersion.before(Version.CURRENT.minimumIndexCompatibilityVersion())) {
            throw new IllegalStateException("cannot upgrade a node from version [" + this.nodeVersion + "] directly to version [" + Version.CURRENT + "]");
        }
        if (this.nodeVersion.after(Version.CURRENT)) {
            throw new IllegalStateException("cannot downgrade a node from version [" + this.nodeVersion + "] to version [" + Version.CURRENT + "]");
        }
        return this.nodeVersion.equals(Version.CURRENT) ? this : new NodeMetaData(this.nodeId, Version.CURRENT);
    }

    static class NodeMetaDataStateFormat
    extends MetaDataStateFormat<NodeMetaData> {
        private ObjectParser<Builder, Void> objectParser;

        NodeMetaDataStateFormat(boolean ignoreUnknownFields) {
            super("node-");
            this.objectParser = new ObjectParser("node_meta_data", ignoreUnknownFields, () -> new Builder());
            this.objectParser.declareString(Builder::setNodeId, new ParseField(NodeMetaData.NODE_ID_KEY, new String[0]));
            this.objectParser.declareInt(Builder::setNodeVersionId, new ParseField(NodeMetaData.NODE_VERSION_KEY, new String[0]));
        }

        @Override
        protected XContentBuilder newXContentBuilder(XContentType type, OutputStream stream) throws IOException {
            XContentBuilder xContentBuilder = super.newXContentBuilder(type, stream);
            xContentBuilder.prettyPrint();
            return xContentBuilder;
        }

        @Override
        public void toXContent(XContentBuilder builder, NodeMetaData nodeMetaData) throws IOException {
            builder.field(NodeMetaData.NODE_ID_KEY, nodeMetaData.nodeId);
            builder.field(NodeMetaData.NODE_VERSION_KEY, ((NodeMetaData)nodeMetaData).nodeVersion.id);
        }

        @Override
        public NodeMetaData fromXContent(XContentParser parser) throws IOException {
            return this.objectParser.apply(parser, null).build();
        }
    }

    private static class Builder {
        String nodeId;
        Version nodeVersion;

        private Builder() {
        }

        public void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        public void setNodeVersionId(int nodeVersionId) {
            this.nodeVersion = Version.fromId(nodeVersionId);
        }

        public NodeMetaData build() {
            Version nodeVersion;
            if (this.nodeVersion == null) {
                assert (Version.CURRENT.major <= Version.V_7_0_0.major + 1) : "version is required in the node metadata from v9 onwards";
                nodeVersion = Version.V_EMPTY;
            } else {
                nodeVersion = this.nodeVersion;
            }
            return new NodeMetaData(this.nodeId, nodeVersion);
        }
    }
}

