/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings;

import java.util.ArrayList;
import java.util.Collections;
import joptsimple.OptionSet;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cli.EnvironmentAwareCommand;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cli.Terminal;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cli.UserException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.KeyStoreWrapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.env.Environment;

class ListKeyStoreCommand
extends EnvironmentAwareCommand {
    ListKeyStoreCommand() {
        super("List entries in the keystore");
    }

    @Override
    protected void execute(Terminal terminal, OptionSet options, Environment env) throws Exception {
        KeyStoreWrapper keystore = KeyStoreWrapper.load(env.configFile());
        if (keystore == null) {
            throw new UserException(65, "Elasticsearch keystore not found. Use 'create' command to create one.");
        }
        keystore.decrypt(new char[0]);
        ArrayList<String> sortedEntries = new ArrayList<String>(keystore.getSettingNames());
        Collections.sort(sortedEntries);
        for (String entry : sortedEntries) {
            terminal.println(entry);
        }
    }
}

