/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.lucene.search.function;

import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.IndexReader;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.Term;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.BooleanClause;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.DocIdSetIterator;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Explanation;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.IndexSearcher;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Query;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.QueryVisitor;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.ScoreMode;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Scorer;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Weight;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ElasticsearchException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.lucene.search.function.MinScoreScorer;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.script.ScoreScript;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.script.Script;

public class ScriptScoreQuery
extends Query {
    private final Query subQuery;
    private final Script script;
    private final ScoreScript.LeafFactory scriptBuilder;
    private final Float minScore;
    private final String indexName;
    private final int shardId;
    private final Version indexVersion;

    public ScriptScoreQuery(Query subQuery, Script script, ScoreScript.LeafFactory scriptBuilder, Float minScore, String indexName, int shardId, Version indexVersion) {
        this.subQuery = subQuery;
        this.script = script;
        this.scriptBuilder = scriptBuilder;
        this.minScore = minScore;
        this.indexName = indexName;
        this.shardId = shardId;
        this.indexVersion = indexVersion;
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        Query newQ = this.subQuery.rewrite(reader);
        if (newQ != this.subQuery) {
            return new ScriptScoreQuery(newQ, this.script, this.scriptBuilder, this.minScore, this.indexName, this.shardId, this.indexVersion);
        }
        return super.rewrite(reader);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        if (scoreMode == ScoreMode.COMPLETE_NO_SCORES && this.minScore == null) {
            return this.subQuery.createWeight(searcher, scoreMode, boost);
        }
        final boolean needsScore = this.scriptBuilder.needs_score();
        ScoreMode subQueryScoreMode = needsScore ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
        final Weight subQueryWeight = this.subQuery.createWeight(searcher, subQueryScoreMode, boost);
        return new Weight(this){

            @Override
            public void extractTerms(Set<Term> terms) {
                subQueryWeight.extractTerms(terms);
            }

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                Scorer subQueryScorer = subQueryWeight.scorer(context);
                if (subQueryScorer == null) {
                    return null;
                }
                Scorer scriptScorer = this.makeScriptScorer(subQueryScorer, context, null);
                if (ScriptScoreQuery.this.minScore != null) {
                    scriptScorer = new MinScoreScorer(this, scriptScorer, ScriptScoreQuery.this.minScore.floatValue());
                }
                return scriptScorer;
            }

            @Override
            public Explanation explain(LeafReaderContext context, int doc) throws IOException {
                Explanation subQueryExplanation = subQueryWeight.explain(context, doc);
                if (!subQueryExplanation.isMatch()) {
                    return subQueryExplanation;
                }
                ScoreScript.ExplanationHolder explanationHolder = new ScoreScript.ExplanationHolder();
                Scorer scorer = this.makeScriptScorer(subQueryWeight.scorer(context), context, explanationHolder);
                int newDoc = scorer.iterator().advance(doc);
                assert (doc == newDoc);
                float score = scorer.score();
                Explanation explanation = explanationHolder.get(score, needsScore ? subQueryExplanation : null);
                if (explanation == null) {
                    String desc = "script score function, computed with script:\"" + ScriptScoreQuery.this.script + "\"";
                    if (needsScore) {
                        Explanation scoreExp = Explanation.match(subQueryExplanation.getValue(), "_score: ", subQueryExplanation);
                        explanation = Explanation.match((Number)Float.valueOf(score), desc, scoreExp);
                    } else {
                        explanation = Explanation.match((Number)Float.valueOf(score), desc, new Explanation[0]);
                    }
                }
                if (ScriptScoreQuery.this.minScore != null && ScriptScoreQuery.this.minScore.floatValue() > explanation.getValue().floatValue()) {
                    explanation = Explanation.noMatch("Score value is too low, expected at least " + ScriptScoreQuery.this.minScore + " but got " + explanation.getValue(), explanation);
                }
                return explanation;
            }

            private Scorer makeScriptScorer(final Scorer subQueryScorer, LeafReaderContext context, final ScoreScript.ExplanationHolder explanation) throws IOException {
                final ScoreScript scoreScript = ScriptScoreQuery.this.scriptBuilder.newInstance(context);
                scoreScript.setScorer(subQueryScorer);
                scoreScript._setIndexName(ScriptScoreQuery.this.indexName);
                scoreScript._setShard(ScriptScoreQuery.this.shardId);
                scoreScript._setIndexVersion(ScriptScoreQuery.this.indexVersion);
                return new Scorer(this){

                    @Override
                    public float score() throws IOException {
                        int docId = this.docID();
                        scoreScript.setDocument(docId);
                        float score = (float)scoreScript.execute(explanation);
                        if (score == Float.NEGATIVE_INFINITY || Float.isNaN(score)) {
                            throw new ElasticsearchException("script score query returned an invalid score: " + score + " for doc: " + docId, new Object[0]);
                        }
                        return score;
                    }

                    @Override
                    public int docID() {
                        return subQueryScorer.docID();
                    }

                    @Override
                    public DocIdSetIterator iterator() {
                        return subQueryScorer.iterator();
                    }

                    @Override
                    public float getMaxScore(int upTo) {
                        return Float.MAX_VALUE;
                    }
                };
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return ScriptScoreQuery.this.minScore == null;
            }
        };
    }

    @Override
    public void visit(QueryVisitor visitor) {
        this.subQuery.visit(visitor.getSubVisitor(BooleanClause.Occur.MUST, this));
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append("script score (").append(this.subQuery.toString(field)).append(", script: ");
        sb.append("{" + this.script.toString() + "}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScriptScoreQuery that = (ScriptScoreQuery)o;
        return this.shardId == that.shardId && this.subQuery.equals(that.subQuery) && this.script.equals(that.script) && Objects.equals(this.minScore, that.minScore) && this.indexName.equals(that.indexName) && this.indexVersion.equals(that.indexVersion);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.subQuery, this.script, this.minScore, this.indexName, this.shardId, this.indexVersion);
    }
}

