/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.inject;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.inject.ContextualCallable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.inject.EncounterImpl;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.inject.InjectorImpl;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.inject.MembersInjector;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.inject.SingleMemberInjector;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.inject.TypeLiteral;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.inject.internal.Errors;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.inject.internal.ErrorsException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.inject.internal.InternalContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.inject.spi.InjectionListener;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.inject.spi.InjectionPoint;

class MembersInjectorImpl<T>
implements MembersInjector<T> {
    private final TypeLiteral<T> typeLiteral;
    private final InjectorImpl injector;
    private final List<SingleMemberInjector> memberInjectors;
    private final List<MembersInjector<? super T>> userMembersInjectors;
    private final List<InjectionListener<? super T>> injectionListeners;

    MembersInjectorImpl(InjectorImpl injector, TypeLiteral<T> typeLiteral, EncounterImpl<T> encounter, List<SingleMemberInjector> memberInjectors) {
        this.injector = injector;
        this.typeLiteral = typeLiteral;
        this.memberInjectors = memberInjectors;
        this.userMembersInjectors = encounter.getMembersInjectors();
        this.injectionListeners = encounter.getInjectionListeners();
    }

    public List<SingleMemberInjector> getMemberInjectors() {
        return this.memberInjectors;
    }

    @Override
    public void injectMembers(T instance) {
        Errors errors = new Errors(this.typeLiteral);
        try {
            this.injectAndNotify(instance, errors);
        }
        catch (ErrorsException e) {
            errors.merge(e.getErrors());
        }
        errors.throwProvisionExceptionIfErrorsExist();
    }

    void injectAndNotify(final T instance, final Errors errors) throws ErrorsException {
        if (instance == null) {
            return;
        }
        this.injector.callInContext(new ContextualCallable<Void>(){

            @Override
            public Void call(InternalContext context) throws ErrorsException {
                MembersInjectorImpl.this.injectMembers(instance, errors, context);
                return null;
            }
        });
        this.notifyListeners(instance, errors);
    }

    void notifyListeners(T instance, Errors errors) throws ErrorsException {
        int numErrorsBefore = errors.size();
        for (InjectionListener<T> injectionListener : this.injectionListeners) {
            try {
                injectionListener.afterInjection(instance);
            }
            catch (RuntimeException e) {
                errors.errorNotifyingInjectionListener(injectionListener, this.typeLiteral, e);
            }
        }
        errors.throwIfNewErrors(numErrorsBefore);
    }

    void injectMembers(T t, Errors errors, InternalContext context) {
        int i;
        int size = this.memberInjectors.size();
        for (i = 0; i < size; ++i) {
            this.memberInjectors.get(i).inject(errors, context, t);
        }
        size = this.userMembersInjectors.size();
        for (i = 0; i < size; ++i) {
            MembersInjector<T> userMembersInjector = this.userMembersInjectors.get(i);
            try {
                userMembersInjector.injectMembers(t);
                continue;
            }
            catch (RuntimeException e) {
                errors.errorInUserInjector(userMembersInjector, this.typeLiteral, e);
            }
        }
    }

    public String toString() {
        return "MembersInjector<" + this.typeLiteral + ">";
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.unmodifiableSet(this.memberInjectors.stream().map(SingleMemberInjector::getInjectionPoint).collect(Collectors.toSet()));
    }
}

