/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common;

import java.util.Base64;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.MacAddressProvider;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.SecureRandomHolder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.UUIDGenerator;

class TimeBasedUUIDGenerator
implements UUIDGenerator {
    private final AtomicInteger sequenceNumber = new AtomicInteger(SecureRandomHolder.INSTANCE.nextInt());
    private long lastTimestamp;
    private static final byte[] SECURE_MUNGED_ADDRESS = MacAddressProvider.getSecureMungedAddress();

    TimeBasedUUIDGenerator() {
    }

    protected long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    protected byte[] macAddress() {
        return SECURE_MUNGED_ADDRESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getBase64UUID() {
        int sequenceId = this.sequenceNumber.incrementAndGet() & 0xFFFFFF;
        long timestamp = this.currentTimeMillis();
        TimeBasedUUIDGenerator timeBasedUUIDGenerator = this;
        synchronized (timeBasedUUIDGenerator) {
            timestamp = Math.max(this.lastTimestamp, timestamp);
            if (sequenceId == 0) {
                ++timestamp;
            }
            this.lastTimestamp = timestamp;
        }
        byte[] uuidBytes = new byte[15];
        int i = 0;
        uuidBytes[i++] = (byte)sequenceId;
        uuidBytes[i++] = (byte)(sequenceId >>> 16);
        uuidBytes[i++] = (byte)(timestamp >>> 16);
        uuidBytes[i++] = (byte)(timestamp >>> 24);
        uuidBytes[i++] = (byte)(timestamp >>> 32);
        uuidBytes[i++] = (byte)(timestamp >>> 40);
        byte[] macAddress = this.macAddress();
        assert (macAddress.length == 6);
        System.arraycopy(macAddress, 0, uuidBytes, i, macAddress.length);
        i += macAddress.length;
        uuidBytes[i++] = (byte)(timestamp >>> 8);
        uuidBytes[i++] = (byte)(sequenceId >>> 8);
        uuidBytes[i++] = (byte)timestamp;
        assert (i == uuidBytes.length);
        return Base64.getUrlEncoder().withoutPadding().encodeToString(uuidBytes);
    }

    static {
        assert (SECURE_MUNGED_ADDRESS.length == 6);
    }
}

