/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.routing.allocation.decider;

import java.util.List;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.routing.RoutingNode;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.routing.ShardRouting;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.ClusterSettings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.Setting;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.Settings;

public class SameShardAllocationDecider
extends AllocationDecider {
    public static final String NAME = "same_shard";
    public static final Setting<Boolean> CLUSTER_ROUTING_ALLOCATION_SAME_HOST_SETTING = Setting.boolSetting("cluster.routing.allocation.same_shard.host", false, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private volatile boolean sameHost;

    public SameShardAllocationDecider(Settings settings, ClusterSettings clusterSettings) {
        this.sameHost = CLUSTER_ROUTING_ALLOCATION_SAME_HOST_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_ROUTING_ALLOCATION_SAME_HOST_SETTING, this::setSameHost);
    }

    private void setSameHost(boolean sameHost) {
        this.sameHost = sameHost;
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        List<ShardRouting> assignedShards = allocation.routingNodes().assignedShards(shardRouting.shardId());
        Decision decision = this.decideSameNode(shardRouting, node, allocation, assignedShards);
        if (decision.type() == Decision.Type.NO || !this.sameHost) {
            return decision;
        }
        if (node.node() != null) {
            for (RoutingNode checkNode : allocation.routingNodes()) {
                if (checkNode.node() == null) continue;
                boolean checkNodeOnSameHostName = false;
                boolean checkNodeOnSameHostAddress = false;
                if (Strings.hasLength(checkNode.node().getHostAddress()) && Strings.hasLength(node.node().getHostAddress())) {
                    if (checkNode.node().getHostAddress().equals(node.node().getHostAddress())) {
                        checkNodeOnSameHostAddress = true;
                    }
                } else if (Strings.hasLength(checkNode.node().getHostName()) && Strings.hasLength(node.node().getHostName()) && checkNode.node().getHostName().equals(node.node().getHostName())) {
                    checkNodeOnSameHostName = true;
                }
                if (!checkNodeOnSameHostAddress && !checkNodeOnSameHostName) continue;
                for (ShardRouting assignedShard : assignedShards) {
                    if (!checkNode.nodeId().equals(assignedShard.currentNodeId())) continue;
                    String hostType = checkNodeOnSameHostAddress ? "address" : "name";
                    String host = checkNodeOnSameHostAddress ? node.node().getHostAddress() : node.node().getHostName();
                    return allocation.decision(Decision.NO, NAME, "the shard cannot be allocated on host %s [%s], where it already exists on node [%s]; set cluster setting [%s] to false to allow multiple nodes on the same host to hold the same shard copies", hostType, host, node.nodeId(), CLUSTER_ROUTING_ALLOCATION_SAME_HOST_SETTING.getKey());
                }
            }
        }
        return allocation.decision(Decision.YES, NAME, "the shard does not exist on the same host", new Object[0]);
    }

    @Override
    public Decision canForceAllocatePrimary(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        assert (shardRouting.primary()) : "must not call force allocate on a non-primary shard";
        List<ShardRouting> assignedShards = allocation.routingNodes().assignedShards(shardRouting.shardId());
        return this.decideSameNode(shardRouting, node, allocation, assignedShards);
    }

    private Decision decideSameNode(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation, Iterable<ShardRouting> assignedShards) {
        for (ShardRouting assignedShard : assignedShards) {
            if (!node.nodeId().equals(assignedShard.currentNodeId())) continue;
            if (assignedShard.isSameAllocation(shardRouting)) {
                return allocation.decision(Decision.NO, NAME, "the shard cannot be allocated to the node on which it already exists [%s]", shardRouting.toString());
            }
            return allocation.decision(Decision.NO, NAME, "the shard cannot be allocated to the same node on which a copy of the shard already exists [%s]", assignedShard.toString());
        }
        return allocation.decision(Decision.YES, NAME, "the shard does not exist on the same node", new Object[0]);
    }
}

