/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.routing.allocation.decider;

import java.util.Collection;
import java.util.Collections;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.IndexMetaData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.routing.RoutingNode;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.routing.ShardRouting;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AllocationDeciders
extends AllocationDecider {
    private static final Logger logger = LogManager.getLogger(AllocationDeciders.class);
    private final Collection<AllocationDecider> allocations;

    public AllocationDeciders(Collection<AllocationDecider> allocations) {
        this.allocations = Collections.unmodifiableCollection(allocations);
    }

    @Override
    public Decision canRebalance(ShardRouting shardRouting, RoutingAllocation allocation) {
        Decision.Multi ret = new Decision.Multi();
        for (AllocationDecider allocationDecider : this.allocations) {
            Decision decision = allocationDecider.canRebalance(shardRouting, allocation);
            if (decision == Decision.NO) {
                if (!allocation.debugDecision()) {
                    return decision;
                }
                ret.add(decision);
                continue;
            }
            if (decision == Decision.ALWAYS || allocation.getDebugMode() == RoutingAllocation.DebugMode.EXCLUDE_YES_DECISIONS && decision.type() == Decision.Type.YES) continue;
            ret.add(decision);
        }
        return ret;
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        if (allocation.shouldIgnoreShardForNode(shardRouting.shardId(), node.nodeId())) {
            return Decision.NO;
        }
        Decision.Multi ret = new Decision.Multi();
        for (AllocationDecider allocationDecider : this.allocations) {
            Decision decision = allocationDecider.canAllocate(shardRouting, node, allocation);
            if (decision == Decision.NO) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Can not allocate [{}] on node [{}] due to [{}]", (Object)shardRouting, (Object)node.node(), (Object)allocationDecider.getClass().getSimpleName());
                }
                if (!allocation.debugDecision()) {
                    return decision;
                }
                ret.add(decision);
                continue;
            }
            if (decision == Decision.ALWAYS || allocation.getDebugMode() == RoutingAllocation.DebugMode.EXCLUDE_YES_DECISIONS && decision.type() == Decision.Type.YES) continue;
            ret.add(decision);
        }
        return ret;
    }

    @Override
    public Decision canRemain(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        if (allocation.shouldIgnoreShardForNode(shardRouting.shardId(), node.nodeId())) {
            if (logger.isTraceEnabled()) {
                logger.trace("Shard [{}] should be ignored for node [{}]", (Object)shardRouting, (Object)node.nodeId());
            }
            return Decision.NO;
        }
        Decision.Multi ret = new Decision.Multi();
        for (AllocationDecider allocationDecider : this.allocations) {
            Decision decision = allocationDecider.canRemain(shardRouting, node, allocation);
            if (decision == Decision.NO) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Shard [{}] can not remain on node [{}] due to [{}]", (Object)shardRouting, (Object)node.nodeId(), (Object)allocationDecider.getClass().getSimpleName());
                }
                if (!allocation.debugDecision()) {
                    return decision;
                }
                ret.add(decision);
                continue;
            }
            if (decision == Decision.ALWAYS || allocation.getDebugMode() == RoutingAllocation.DebugMode.EXCLUDE_YES_DECISIONS && decision.type() == Decision.Type.YES) continue;
            ret.add(decision);
        }
        return ret;
    }

    @Override
    public Decision canAllocate(IndexMetaData indexMetaData, RoutingNode node, RoutingAllocation allocation) {
        Decision.Multi ret = new Decision.Multi();
        for (AllocationDecider allocationDecider : this.allocations) {
            Decision decision = allocationDecider.canAllocate(indexMetaData, node, allocation);
            if (decision == Decision.NO) {
                if (!allocation.debugDecision()) {
                    return decision;
                }
                ret.add(decision);
                continue;
            }
            if (decision == Decision.ALWAYS || allocation.getDebugMode() == RoutingAllocation.DebugMode.EXCLUDE_YES_DECISIONS && decision.type() == Decision.Type.YES) continue;
            ret.add(decision);
        }
        return ret;
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingAllocation allocation) {
        Decision.Multi ret = new Decision.Multi();
        for (AllocationDecider allocationDecider : this.allocations) {
            Decision decision = allocationDecider.canAllocate(shardRouting, allocation);
            if (decision == Decision.NO) {
                if (!allocation.debugDecision()) {
                    return decision;
                }
                ret.add(decision);
                continue;
            }
            if (decision == Decision.ALWAYS || allocation.getDebugMode() == RoutingAllocation.DebugMode.EXCLUDE_YES_DECISIONS && decision.type() == Decision.Type.YES) continue;
            ret.add(decision);
        }
        return ret;
    }

    @Override
    public Decision canAllocate(RoutingNode node, RoutingAllocation allocation) {
        Decision.Multi ret = new Decision.Multi();
        for (AllocationDecider allocationDecider : this.allocations) {
            Decision decision = allocationDecider.canAllocate(node, allocation);
            if (decision == Decision.NO) {
                if (!allocation.debugDecision()) {
                    return decision;
                }
                ret.add(decision);
                continue;
            }
            if (decision == Decision.ALWAYS || allocation.getDebugMode() == RoutingAllocation.DebugMode.EXCLUDE_YES_DECISIONS && decision.type() == Decision.Type.YES) continue;
            ret.add(decision);
        }
        return ret;
    }

    @Override
    public Decision canRebalance(RoutingAllocation allocation) {
        Decision.Multi ret = new Decision.Multi();
        for (AllocationDecider allocationDecider : this.allocations) {
            Decision decision = allocationDecider.canRebalance(allocation);
            if (decision == Decision.NO) {
                if (!allocation.debugDecision()) {
                    return decision;
                }
                ret.add(decision);
                continue;
            }
            if (decision == Decision.ALWAYS || allocation.getDebugMode() == RoutingAllocation.DebugMode.EXCLUDE_YES_DECISIONS && decision.type() == Decision.Type.YES) continue;
            ret.add(decision);
        }
        return ret;
    }

    @Override
    public Decision canForceAllocatePrimary(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        assert (shardRouting.primary()) : "must not call canForceAllocatePrimary on a non-primary shard routing " + shardRouting;
        if (allocation.shouldIgnoreShardForNode(shardRouting.shardId(), node.nodeId())) {
            return Decision.NO;
        }
        Decision.Multi ret = new Decision.Multi();
        for (AllocationDecider decider : this.allocations) {
            Decision decision = decider.canForceAllocatePrimary(shardRouting, node, allocation);
            if (decision == Decision.NO) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Shard [{}] can not be forcefully allocated to node [{}] due to [{}].", (Object)shardRouting.shardId(), (Object)node.nodeId(), (Object)decider.getClass().getSimpleName());
                }
                if (!allocation.debugDecision()) {
                    return decision;
                }
                ret.add(decision);
                continue;
            }
            if (decision == Decision.ALWAYS || allocation.getDebugMode() == RoutingAllocation.DebugMode.EXCLUDE_YES_DECISIONS && decision.type() == Decision.Type.YES) continue;
            ret.add(decision);
        }
        return ret;
    }
}

