/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.coordination;

import java.io.IOException;
import java.util.Optional;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.coordination.Join;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.node.DiscoveryNode;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportRequest;

public class JoinRequest
extends TransportRequest {
    private final DiscoveryNode sourceNode;
    private final Optional<Join> optionalJoin;

    public JoinRequest(DiscoveryNode sourceNode, Optional<Join> optionalJoin) {
        assert (!optionalJoin.isPresent() || optionalJoin.get().getSourceNode().equals(sourceNode));
        this.sourceNode = sourceNode;
        this.optionalJoin = optionalJoin;
    }

    public JoinRequest(StreamInput in) throws IOException {
        super(in);
        this.sourceNode = new DiscoveryNode(in);
        this.optionalJoin = Optional.ofNullable(in.readOptionalWriteable(Join::new));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.sourceNode.writeTo(out);
        out.writeOptionalWriteable(this.optionalJoin.orElse(null));
    }

    public DiscoveryNode getSourceNode() {
        return this.sourceNode;
    }

    public Optional<Join> getOptionalJoin() {
        return this.optionalJoin;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JoinRequest)) {
            return false;
        }
        JoinRequest that = (JoinRequest)o;
        if (!this.sourceNode.equals(that.sourceNode)) {
            return false;
        }
        return this.optionalJoin.equals(that.optionalJoin);
    }

    public int hashCode() {
        int result = this.sourceNode.hashCode();
        result = 31 * result + this.optionalJoin.hashCode();
        return result;
    }

    public String toString() {
        return "JoinRequest{sourceNode=" + this.sourceNode + ", optionalJoin=" + this.optionalJoin + '}';
    }
}

