/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml.dataframe;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml.dataframe.QueryConfig;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentObject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;

public class DataFrameAnalyticsSource
implements ToXContentObject {
    private static final ParseField INDEX = new ParseField("index", new String[0]);
    private static final ParseField QUERY = new ParseField("query", new String[0]);
    private static ObjectParser<Builder, Void> PARSER = new ObjectParser("data_frame_analytics_source", true, () -> new Builder());
    private final String[] index;
    private final QueryConfig queryConfig;

    public static DataFrameAnalyticsSource fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private DataFrameAnalyticsSource(String[] index, @Nullable QueryConfig queryConfig) {
        this.index = Objects.requireNonNull(index);
        this.queryConfig = queryConfig;
    }

    public String[] getIndex() {
        return this.index;
    }

    public QueryConfig getQueryConfig() {
        return this.queryConfig;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(INDEX.getPreferredName(), this.index);
        if (this.queryConfig != null) {
            builder.field(QUERY.getPreferredName(), this.queryConfig.getQuery());
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataFrameAnalyticsSource other = (DataFrameAnalyticsSource)o;
        return Arrays.equals(this.index, other.index) && Objects.equals(this.queryConfig, other.queryConfig);
    }

    public int hashCode() {
        return Objects.hash(Arrays.asList(this.index), this.queryConfig);
    }

    public String toString() {
        return Strings.toString(this);
    }

    static {
        PARSER.declareStringArray(Builder::setIndex, INDEX);
        PARSER.declareObject(Builder::setQueryConfig, (p, c) -> QueryConfig.fromXContent(p), QUERY);
    }

    public static class Builder {
        private String[] index;
        private QueryConfig queryConfig;

        private Builder() {
        }

        public Builder setIndex(String ... index) {
            this.index = index;
            return this;
        }

        public Builder setIndex(List<String> index) {
            this.index = index.toArray(new String[0]);
            return this;
        }

        public Builder setQueryConfig(QueryConfig queryConfig) {
            this.queryConfig = queryConfig;
            return this;
        }

        public DataFrameAnalyticsSource build() {
            return new DataFrameAnalyticsSource(this.index, this.queryConfig);
        }
    }
}

