/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client;

import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.cluster.node.tasks.cancel.CancelTasksRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.Request;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.RequestConverters;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.tasks.GetTaskRequest;

final class TasksRequestConverters {
    private TasksRequestConverters() {
    }

    static Request cancelTasks(CancelTasksRequest cancelTasksRequest) {
        Request request = new Request("POST", "/_tasks/_cancel");
        RequestConverters.Params params = new RequestConverters.Params();
        params.withTimeout(cancelTasksRequest.getTimeout()).withTaskId(cancelTasksRequest.getTaskId()).withNodes(cancelTasksRequest.getNodes()).withParentTaskId(cancelTasksRequest.getParentTaskId()).withActions(cancelTasksRequest.getActions());
        request.addParameters(params.asMap());
        return request;
    }

    static Request listTasks(ListTasksRequest listTaskRequest) {
        if (listTaskRequest.getTaskId() != null && listTaskRequest.getTaskId().isSet()) {
            throw new IllegalArgumentException("TaskId cannot be used for list tasks request");
        }
        Request request = new Request("GET", "/_tasks");
        RequestConverters.Params params = new RequestConverters.Params();
        params.withTimeout(listTaskRequest.getTimeout()).withDetailed(listTaskRequest.getDetailed()).withWaitForCompletion(listTaskRequest.getWaitForCompletion()).withParentTaskId(listTaskRequest.getParentTaskId()).withNodes(listTaskRequest.getNodes()).withActions(listTaskRequest.getActions()).putParam("group_by", "none");
        request.addParameters(params.asMap());
        return request;
    }

    static Request getTask(GetTaskRequest getTaskRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_tasks").addPathPartAsIs(getTaskRequest.getNodeId() + ":" + Long.toString(getTaskRequest.getTaskId())).build();
        Request request = new Request("GET", endpoint);
        RequestConverters.Params params = new RequestConverters.Params();
        params.withTimeout(getTaskRequest.getTimeout()).withWaitForCompletion(getTaskRequest.getWaitForCompletion());
        request.addParameters(params.asMap());
        return request;
    }
}

