/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client;

import java.util.function.Supplier;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.ContextPreservingActionListener;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.Client;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.FilterClient;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.util.concurrent.ThreadContext;

public final class OriginSettingClient
extends FilterClient {
    private final String origin;

    public OriginSettingClient(Client in, String origin) {
        super(in);
        this.origin = origin;
    }

    @Override
    protected <Request extends ActionRequest, Response extends ActionResponse> void doExecute(ActionType<Response> action, Request request, ActionListener<Response> listener) {
        Supplier<ThreadContext.StoredContext> supplier = this.in().threadPool().getThreadContext().newRestorableContext(false);
        try (ThreadContext.StoredContext ignore = this.in().threadPool().getThreadContext().stashWithOrigin(this.origin);){
            super.doExecute(action, request, new ContextPreservingActionListener<Response>(supplier, listener));
        }
    }
}

