/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.bootstrap;

import java.io.FilePermission;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.Permissions;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.bootstrap.JavaVersion;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.bootstrap.Security;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.SuppressForbidden;

public class FilePermissionUtils {
    private static final boolean VERSION_IS_AT_LEAST_JAVA_9 = JavaVersion.current().compareTo(JavaVersion.parse("9")) >= 0;

    private FilePermissionUtils() {
    }

    @SuppressForbidden(reason="only place where creating Java-9 compatible FilePermission objects is possible")
    public static void addSingleFilePath(Permissions policy, Path path, String permissions) throws IOException {
        policy.add(new FilePermission(path.toString(), permissions));
        if (VERSION_IS_AT_LEAST_JAVA_9 && Files.exists(path, new LinkOption[0])) {
            Path realPath = path.toRealPath(new LinkOption[0]);
            if (!path.toString().equals(realPath.toString())) {
                policy.add(new FilePermission(realPath.toString(), permissions));
            }
        }
    }

    @SuppressForbidden(reason="only place where creating Java-9 compatible FilePermission objects is possible")
    public static void addDirectoryPath(Permissions policy, String configurationName, Path path, String permissions) throws IOException {
        try {
            Security.ensureDirectoryExists(path);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to access '" + configurationName + "' (" + path + ")", e);
        }
        policy.add(new FilePermission(path.toString(), permissions));
        policy.add(new FilePermission(path.toString() + path.getFileSystem().getSeparator() + "-", permissions));
        if (VERSION_IS_AT_LEAST_JAVA_9) {
            Path realPath = path.toRealPath(new LinkOption[0]);
            if (!path.toString().equals(realPath.toString())) {
                policy.add(new FilePermission(realPath.toString(), permissions));
                policy.add(new FilePermission(realPath.toString() + realPath.getFileSystem().getSeparator() + "-", permissions));
            }
        }
    }
}

