/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support;

import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportChannel;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;

public final class ChannelActionListener<Response extends TransportResponse, Request extends TransportRequest>
implements ActionListener<Response> {
    private static final Logger logger = LogManager.getLogger(ChannelActionListener.class);
    private final TransportChannel channel;
    private final Request request;
    private final String actionName;

    public ChannelActionListener(TransportChannel channel, String actionName, Request request) {
        this.channel = channel;
        this.request = request;
        this.actionName = actionName;
    }

    @Override
    public void onResponse(Response response) {
        try {
            this.channel.sendResponse((TransportResponse)response);
        }
        catch (Exception e) {
            this.onFailure(e);
        }
    }

    @Override
    public void onFailure(Exception e) {
        try {
            this.channel.sendResponse(e);
        }
        catch (Exception e1) {
            e1.addSuppressed(e);
            logger.warn(() -> new ParameterizedMessage("Failed to send error response for action [{}] and request [{}]", (Object)this.actionName, this.request), (Throwable)e1);
        }
    }
}

