/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.TotalHits;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.search.SearchResponseSections;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.search.ShardSearchFailure;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.Writeable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.unit.TimeValue;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.StatusToXContentObject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentFragment;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParserUtils;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestStatus;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.action.RestActions;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.SearchHit;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.SearchHits;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.Aggregations;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.InternalAggregations;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.internal.InternalSearchResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.profile.ProfileShardResult;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.profile.SearchProfileShardResults;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.suggest.Suggest;

public class SearchResponse
extends ActionResponse
implements StatusToXContentObject {
    private static final ParseField SCROLL_ID = new ParseField("_scroll_id", new String[0]);
    private static final ParseField TOOK = new ParseField("took", new String[0]);
    private static final ParseField TIMED_OUT = new ParseField("timed_out", new String[0]);
    private static final ParseField TERMINATED_EARLY = new ParseField("terminated_early", new String[0]);
    private static final ParseField NUM_REDUCE_PHASES = new ParseField("num_reduce_phases", new String[0]);
    private final SearchResponseSections internalResponse;
    private final String scrollId;
    private final int totalShards;
    private final int successfulShards;
    private final int skippedShards;
    private final ShardSearchFailure[] shardFailures;
    private final Clusters clusters;
    private final long tookInMillis;

    public SearchResponse(StreamInput in) throws IOException {
        super(in);
        this.internalResponse = new InternalSearchResponse(in);
        this.totalShards = in.readVInt();
        this.successfulShards = in.readVInt();
        int size = in.readVInt();
        if (size == 0) {
            this.shardFailures = ShardSearchFailure.EMPTY_ARRAY;
        } else {
            this.shardFailures = new ShardSearchFailure[size];
            for (int i = 0; i < this.shardFailures.length; ++i) {
                this.shardFailures[i] = ShardSearchFailure.readShardSearchFailure(in);
            }
        }
        this.clusters = in.getVersion().onOrAfter(Version.V_6_1_0) ? new Clusters(in) : Clusters.EMPTY;
        this.scrollId = in.readOptionalString();
        this.tookInMillis = in.readVLong();
        this.skippedShards = in.readVInt();
    }

    public SearchResponse(SearchResponseSections internalResponse, String scrollId, int totalShards, int successfulShards, int skippedShards, long tookInMillis, ShardSearchFailure[] shardFailures, Clusters clusters) {
        this.internalResponse = internalResponse;
        this.scrollId = scrollId;
        this.clusters = clusters;
        this.totalShards = totalShards;
        this.successfulShards = successfulShards;
        this.skippedShards = skippedShards;
        this.tookInMillis = tookInMillis;
        this.shardFailures = shardFailures;
        assert (skippedShards <= totalShards) : "skipped: " + skippedShards + " total: " + totalShards;
    }

    @Override
    public RestStatus status() {
        return RestStatus.status(this.successfulShards, this.totalShards, this.shardFailures);
    }

    public SearchHits getHits() {
        return this.internalResponse.hits();
    }

    public Aggregations getAggregations() {
        return this.internalResponse.aggregations();
    }

    public Suggest getSuggest() {
        return this.internalResponse.suggest();
    }

    public boolean isTimedOut() {
        return this.internalResponse.timedOut();
    }

    public Boolean isTerminatedEarly() {
        return this.internalResponse.terminatedEarly();
    }

    public int getNumReducePhases() {
        return this.internalResponse.getNumReducePhases();
    }

    public TimeValue getTook() {
        return new TimeValue(this.tookInMillis);
    }

    public int getTotalShards() {
        return this.totalShards;
    }

    public int getSuccessfulShards() {
        return this.successfulShards;
    }

    public int getSkippedShards() {
        return this.skippedShards;
    }

    public int getFailedShards() {
        return this.shardFailures.length;
    }

    public ShardSearchFailure[] getShardFailures() {
        return this.shardFailures;
    }

    public String getScrollId() {
        return this.scrollId;
    }

    @Nullable
    public Map<String, ProfileShardResult> getProfileResults() {
        return this.internalResponse.profile();
    }

    public Clusters getClusters() {
        return this.clusters;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.innerToXContent(builder, params);
        builder.endObject();
        return builder;
    }

    public XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.scrollId != null) {
            builder.field(SCROLL_ID.getPreferredName(), this.scrollId);
        }
        builder.field(TOOK.getPreferredName(), this.tookInMillis);
        builder.field(TIMED_OUT.getPreferredName(), this.isTimedOut());
        if (this.isTerminatedEarly() != null) {
            builder.field(TERMINATED_EARLY.getPreferredName(), this.isTerminatedEarly());
        }
        if (this.getNumReducePhases() != 1) {
            builder.field(NUM_REDUCE_PHASES.getPreferredName(), this.getNumReducePhases());
        }
        RestActions.buildBroadcastShardsHeader(builder, params, this.getTotalShards(), this.getSuccessfulShards(), this.getSkippedShards(), this.getFailedShards(), this.getShardFailures());
        this.clusters.toXContent(builder, params);
        this.internalResponse.toXContent(builder, params);
        return builder;
    }

    public static SearchResponse fromXContent(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.nextToken(), parser::getTokenLocation);
        parser.nextToken();
        return SearchResponse.innerFromXContent(parser);
    }

    static SearchResponse innerFromXContent(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, parser.currentToken(), parser::getTokenLocation);
        String currentFieldName = parser.currentName();
        SearchHits hits = null;
        Aggregations aggs = null;
        Suggest suggest = null;
        SearchProfileShardResults profile = null;
        boolean timedOut = false;
        Boolean terminatedEarly = null;
        int numReducePhases = 1;
        long tookInMillis = -1L;
        int successfulShards = -1;
        int totalShards = -1;
        int skippedShards = 0;
        String scrollId = null;
        ArrayList<ShardSearchFailure> failures = new ArrayList<ShardSearchFailure>();
        Clusters clusters = Clusters.EMPTY;
        XContentParser.Token token = parser.nextToken();
        while (token != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
            } else if (token.isValue()) {
                if (SCROLL_ID.match(currentFieldName, parser.getDeprecationHandler())) {
                    scrollId = parser.text();
                } else if (TOOK.match(currentFieldName, parser.getDeprecationHandler())) {
                    tookInMillis = parser.longValue();
                } else if (TIMED_OUT.match(currentFieldName, parser.getDeprecationHandler())) {
                    timedOut = parser.booleanValue();
                } else if (TERMINATED_EARLY.match(currentFieldName, parser.getDeprecationHandler())) {
                    terminatedEarly = parser.booleanValue();
                } else if (NUM_REDUCE_PHASES.match(currentFieldName, parser.getDeprecationHandler())) {
                    numReducePhases = parser.intValue();
                } else {
                    parser.skipChildren();
                }
            } else if (token == XContentParser.Token.START_OBJECT) {
                if ("hits".equals(currentFieldName)) {
                    hits = SearchHits.fromXContent(parser);
                } else if ("aggregations".equals(currentFieldName)) {
                    aggs = Aggregations.fromXContent(parser);
                } else if ("suggest".equals(currentFieldName)) {
                    suggest = Suggest.fromXContent(parser);
                } else if ("profile".equals(currentFieldName)) {
                    profile = SearchProfileShardResults.fromXContent(parser);
                } else if (RestActions._SHARDS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            currentFieldName = parser.currentName();
                            continue;
                        }
                        if (token.isValue()) {
                            if (RestActions.FAILED_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                                parser.intValue();
                                continue;
                            }
                            if (RestActions.SUCCESSFUL_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                                successfulShards = parser.intValue();
                                continue;
                            }
                            if (RestActions.TOTAL_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                                totalShards = parser.intValue();
                                continue;
                            }
                            if (RestActions.SKIPPED_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                                skippedShards = parser.intValue();
                                continue;
                            }
                            parser.skipChildren();
                            continue;
                        }
                        if (token == XContentParser.Token.START_ARRAY) {
                            if (RestActions.FAILURES_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                                    failures.add(ShardSearchFailure.fromXContent(parser));
                                }
                                continue;
                            }
                            parser.skipChildren();
                            continue;
                        }
                        parser.skipChildren();
                    }
                } else if (Clusters._CLUSTERS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    int successful = -1;
                    int total = -1;
                    int skipped = -1;
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            currentFieldName = parser.currentName();
                            continue;
                        }
                        if (token.isValue()) {
                            if (Clusters.SUCCESSFUL_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                                successful = parser.intValue();
                                continue;
                            }
                            if (Clusters.TOTAL_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                                total = parser.intValue();
                                continue;
                            }
                            if (Clusters.SKIPPED_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                                skipped = parser.intValue();
                                continue;
                            }
                            parser.skipChildren();
                            continue;
                        }
                        parser.skipChildren();
                    }
                    clusters = new Clusters(total, successful, skipped);
                } else {
                    parser.skipChildren();
                }
            }
            token = parser.nextToken();
        }
        SearchResponseSections searchResponseSections = new SearchResponseSections(hits, aggs, suggest, timedOut, terminatedEarly, profile, numReducePhases);
        return new SearchResponse(searchResponseSections, scrollId, totalShards, successfulShards, skippedShards, tookInMillis, failures.toArray(ShardSearchFailure.EMPTY_ARRAY), clusters);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.internalResponse.writeTo(out);
        out.writeVInt(this.totalShards);
        out.writeVInt(this.successfulShards);
        out.writeVInt(this.shardFailures.length);
        for (ShardSearchFailure shardSearchFailure : this.shardFailures) {
            shardSearchFailure.writeTo(out);
        }
        if (out.getVersion().onOrAfter(Version.V_6_1_0)) {
            this.clusters.writeTo(out);
        }
        out.writeOptionalString(this.scrollId);
        out.writeVLong(this.tookInMillis);
        out.writeVInt(this.skippedShards);
    }

    public String toString() {
        return Strings.toString(this);
    }

    static SearchResponse empty(Supplier<Long> tookInMillisSupplier, Clusters clusters) {
        SearchHits searchHits = new SearchHits(new SearchHit[0], new TotalHits(0L, TotalHits.Relation.EQUAL_TO), Float.NaN);
        InternalSearchResponse internalSearchResponse = new InternalSearchResponse(searchHits, InternalAggregations.EMPTY, null, null, false, null, 0);
        return new SearchResponse(internalSearchResponse, null, 0, 0, 0, tookInMillisSupplier.get(), ShardSearchFailure.EMPTY_ARRAY, clusters);
    }

    public static class Clusters
    implements ToXContentFragment,
    Writeable {
        public static final Clusters EMPTY = new Clusters(0, 0, 0);
        static final ParseField _CLUSTERS_FIELD = new ParseField("_clusters", new String[0]);
        static final ParseField SUCCESSFUL_FIELD = new ParseField("successful", new String[0]);
        static final ParseField SKIPPED_FIELD = new ParseField("skipped", new String[0]);
        static final ParseField TOTAL_FIELD = new ParseField("total", new String[0]);
        private final int total;
        private final int successful;
        private final int skipped;

        public Clusters(int total, int successful, int skipped) {
            assert (total >= 0 && successful >= 0 && skipped >= 0) : "total: " + total + " successful: " + successful + " skipped: " + skipped;
            assert (successful <= total && skipped == total - successful) : "total: " + total + " successful: " + successful + " skipped: " + skipped;
            this.total = total;
            this.successful = successful;
            this.skipped = skipped;
        }

        private Clusters(StreamInput in) throws IOException {
            this.total = in.readVInt();
            this.successful = in.readVInt();
            this.skipped = in.readVInt();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.total);
            out.writeVInt(this.successful);
            out.writeVInt(this.skipped);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (this != EMPTY) {
                builder.startObject(_CLUSTERS_FIELD.getPreferredName());
                builder.field(TOTAL_FIELD.getPreferredName(), this.total);
                builder.field(SUCCESSFUL_FIELD.getPreferredName(), this.successful);
                builder.field(SKIPPED_FIELD.getPreferredName(), this.skipped);
                builder.endObject();
            }
            return builder;
        }

        public int getTotal() {
            return this.total;
        }

        public int getSuccessful() {
            return this.successful;
        }

        public int getSkipped() {
            return this.skipped;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Clusters clusters = (Clusters)o;
            return this.total == clusters.total && this.successful == clusters.successful && this.skipped == clusters.skipped;
        }

        public int hashCode() {
            return Objects.hash(this.total, this.successful, this.skipped);
        }

        public String toString() {
            return "Clusters{total=" + this.total + ", successful=" + this.successful + ", skipped=" + this.skipped + '}';
        }
    }
}

