/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.fieldcaps;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.OriginalIndices;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.fieldcaps.FieldCapabilities;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.fieldcaps.FieldCapabilitiesIndexRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.fieldcaps.FieldCapabilitiesIndexResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.fieldcaps.FieldCapabilitiesRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.fieldcaps.FieldCapabilitiesResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.fieldcaps.TransportFieldCapabilitiesIndexAction;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.ActionFilters;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.HandledTransportAction;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.Client;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.ClusterState;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.service.ClusterService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.inject.Inject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.util.concurrent.CountDown;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.tasks.Task;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.threadpool.ThreadPool;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.RemoteClusterAware;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.RemoteClusterService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportService;

public class TransportFieldCapabilitiesAction
extends HandledTransportAction<FieldCapabilitiesRequest, FieldCapabilitiesResponse> {
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final TransportFieldCapabilitiesIndexAction shardAction;
    private final RemoteClusterService remoteClusterService;
    private final IndexNameExpressionResolver indexNameExpressionResolver;

    @Inject
    public TransportFieldCapabilitiesAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, TransportFieldCapabilitiesIndexAction shardAction, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:data/read/field_caps", transportService, actionFilters, FieldCapabilitiesRequest::new);
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.remoteClusterService = transportService.getRemoteClusterService();
        this.shardAction = shardAction;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
    }

    @Override
    protected void doExecute(Task task, FieldCapabilitiesRequest request, ActionListener<FieldCapabilitiesResponse> listener) {
        ClusterState clusterState = this.clusterService.state();
        Map<String, OriginalIndices> remoteClusterIndices = this.remoteClusterService.groupIndices(request.indicesOptions(), request.indices(), idx -> this.indexNameExpressionResolver.hasIndexOrAlias((String)idx, clusterState));
        OriginalIndices localIndices = remoteClusterIndices.remove("");
        String[] concreteIndices = localIndices == null ? Strings.EMPTY_ARRAY : this.indexNameExpressionResolver.concreteIndexNames(clusterState, localIndices);
        String[] allIndices = this.mergeIndiceNames(concreteIndices, remoteClusterIndices);
        int totalNumRequest = concreteIndices.length + remoteClusterIndices.size();
        CountDown completionCounter = new CountDown(totalNumRequest);
        final List indexResponses = Collections.synchronizedList(new ArrayList());
        final Runnable onResponse = () -> {
            if (completionCounter.countDown()) {
                if (request.isMergeResults()) {
                    listener.onResponse(this.merge(allIndices, indexResponses, request.includeUnmapped()));
                } else {
                    listener.onResponse(new FieldCapabilitiesResponse(indexResponses));
                }
            }
        };
        if (totalNumRequest == 0) {
            listener.onResponse(new FieldCapabilitiesResponse(allIndices, Collections.emptyMap()));
        } else {
            ActionListener<FieldCapabilitiesIndexResponse> innerListener = new ActionListener<FieldCapabilitiesIndexResponse>(){

                @Override
                public void onResponse(FieldCapabilitiesIndexResponse result) {
                    indexResponses.add(result);
                    onResponse.run();
                }

                @Override
                public void onFailure(Exception e) {
                    onResponse.run();
                }
            };
            for (String index : concreteIndices) {
                this.shardAction.execute(new FieldCapabilitiesIndexRequest(request.fields(), index, localIndices), innerListener);
            }
            for (Map.Entry entry : remoteClusterIndices.entrySet()) {
                String clusterAlias = (String)entry.getKey();
                OriginalIndices originalIndices = (OriginalIndices)entry.getValue();
                Client remoteClusterClient = this.remoteClusterService.getRemoteClusterClient(this.threadPool, clusterAlias);
                FieldCapabilitiesRequest remoteRequest = new FieldCapabilitiesRequest();
                remoteRequest.setMergeResults(false);
                remoteRequest.indicesOptions(originalIndices.indicesOptions());
                remoteRequest.indices(originalIndices.indices());
                remoteRequest.fields(request.fields());
                remoteClusterClient.fieldCaps(remoteRequest, ActionListener.wrap(response -> {
                    for (FieldCapabilitiesIndexResponse res : response.getIndexResponses()) {
                        indexResponses.add(new FieldCapabilitiesIndexResponse(RemoteClusterAware.buildRemoteIndexName(clusterAlias, res.getIndexName()), res.get()));
                    }
                    onResponse.run();
                }, failure -> onResponse.run()));
            }
        }
    }

    private String[] mergeIndiceNames(String[] localIndices, Map<String, OriginalIndices> remoteIndices) {
        HashSet<String> allIndices = new HashSet<String>();
        Arrays.stream(localIndices).forEach(allIndices::add);
        for (Map.Entry<String, OriginalIndices> entry : remoteIndices.entrySet()) {
            for (String index : entry.getValue().indices()) {
                allIndices.add(RemoteClusterAware.buildRemoteIndexName(entry.getKey(), index));
            }
        }
        return (String[])allIndices.stream().toArray(String[]::new);
    }

    private FieldCapabilitiesResponse merge(String[] indices, List<FieldCapabilitiesIndexResponse> indexResponses, boolean includeUnmapped) {
        HashMap<String, Map<String, FieldCapabilities.Builder>> responseMapBuilder = new HashMap<String, Map<String, FieldCapabilities.Builder>>();
        for (FieldCapabilitiesIndexResponse response : indexResponses) {
            this.innerMerge(responseMapBuilder, response.getIndexName(), response.get());
        }
        HashMap responseMap = new HashMap();
        for (Map.Entry entry : responseMapBuilder.entrySet()) {
            Map typeMapBuilder = (Map)entry.getValue();
            if (includeUnmapped) {
                this.addUnmappedFields(indices, (String)entry.getKey(), typeMapBuilder);
            }
            boolean multiTypes = typeMapBuilder.size() > 1;
            HashMap<String, FieldCapabilities> typeMap = new HashMap<String, FieldCapabilities>();
            for (Map.Entry fieldEntry : typeMapBuilder.entrySet()) {
                typeMap.put((String)fieldEntry.getKey(), ((FieldCapabilities.Builder)fieldEntry.getValue()).build(multiTypes));
            }
            responseMap.put((String)entry.getKey(), Collections.unmodifiableMap(typeMap));
        }
        return new FieldCapabilitiesResponse(indices, Collections.unmodifiableMap(responseMap));
    }

    private void addUnmappedFields(String[] indices, String field, Map<String, FieldCapabilities.Builder> typeMap) {
        HashSet unmappedIndices = new HashSet();
        Arrays.stream(indices).forEach(unmappedIndices::add);
        typeMap.values().stream().forEach(b -> b.getIndices().stream().forEach(unmappedIndices::remove));
        if (!unmappedIndices.isEmpty()) {
            FieldCapabilities.Builder unmapped = new FieldCapabilities.Builder(field, "unmapped");
            typeMap.put("unmapped", unmapped);
            for (String index : unmappedIndices) {
                unmapped.add(index, false, false);
            }
        }
    }

    private void innerMerge(Map<String, Map<String, FieldCapabilities.Builder>> responseMapBuilder, String indexName, Map<String, FieldCapabilities> map) {
        for (Map.Entry<String, FieldCapabilities> entry : map.entrySet()) {
            String field = entry.getKey();
            FieldCapabilities fieldCap = entry.getValue();
            Map typeMap = responseMapBuilder.computeIfAbsent(field, f -> new HashMap());
            FieldCapabilities.Builder builder = typeMap.computeIfAbsent(fieldCap.getType(), key -> new FieldCapabilities.Builder(field, (String)key));
            builder.add(indexName, fieldCap.isSearchable(), fieldCap.isAggregatable());
        }
    }
}

