/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.CorruptIndexException;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ElasticsearchException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ElasticsearchWrapperException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ShardOperationFailedException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.Index;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestStatus;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ExceptionsHelper {
    private static final Logger logger = LogManager.getLogger(ExceptionsHelper.class);
    private static final List<Class<? extends IOException>> CORRUPTION_EXCEPTIONS = Arrays.asList(CorruptIndexException.class, IndexFormatTooOldException.class, IndexFormatTooNewException.class);

    public static RuntimeException convertToRuntime(Exception e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new ElasticsearchException(e);
    }

    public static ElasticsearchException convertToElastic(Exception e) {
        if (e instanceof ElasticsearchException) {
            return (ElasticsearchException)e;
        }
        return new ElasticsearchException(e);
    }

    public static RestStatus status(Throwable t) {
        if (t != null) {
            if (t instanceof ElasticsearchException) {
                return ((ElasticsearchException)t).status();
            }
            if (t instanceof IllegalArgumentException) {
                return RestStatus.BAD_REQUEST;
            }
            if (t instanceof EsRejectedExecutionException) {
                return RestStatus.TOO_MANY_REQUESTS;
            }
        }
        return RestStatus.INTERNAL_SERVER_ERROR;
    }

    public static Throwable unwrapCause(Throwable t) {
        int counter = 0;
        Throwable result = t;
        while (result instanceof ElasticsearchWrapperException) {
            if (result.getCause() == null) {
                return result;
            }
            if (result.getCause() == result) {
                return result;
            }
            if (counter++ > 10) {
                logger.warn("Exception cause unwrapping ran for 10 levels...", t);
                return result;
            }
            result = result.getCause();
        }
        return result;
    }

    @Deprecated
    public static String detailedMessage(Throwable t) {
        if (t == null) {
            return "Unknown";
        }
        if (t.getCause() != null) {
            StringBuilder sb = new StringBuilder();
            while (t != null) {
                sb.append(t.getClass().getSimpleName());
                if (t.getMessage() != null) {
                    sb.append("[");
                    sb.append(t.getMessage());
                    sb.append("]");
                }
                sb.append("; ");
                if ((t = t.getCause()) == null) continue;
                sb.append("nested: ");
            }
            return sb.toString();
        }
        return t.getClass().getSimpleName() + "[" + t.getMessage() + "]";
    }

    public static String stackTrace(Throwable e) {
        StringWriter stackTraceStringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stackTraceStringWriter);
        e.printStackTrace(printWriter);
        return stackTraceStringWriter.toString();
    }

    public static String formatStackTrace(StackTraceElement[] stackTrace) {
        return Arrays.stream(stackTrace).skip(1L).map(e -> "\tat " + e).collect(Collectors.joining("\n"));
    }

    public static <T extends Throwable> void rethrowAndSuppress(List<T> exceptions) throws T {
        Throwable main = null;
        for (Throwable ex : exceptions) {
            main = ExceptionsHelper.useOrSuppress(main, ex);
        }
        if (main != null) {
            throw main;
        }
    }

    public static <T extends Throwable> void maybeThrowRuntimeAndSuppress(List<T> exceptions) {
        Throwable main = null;
        for (Throwable ex : exceptions) {
            main = ExceptionsHelper.useOrSuppress(main, ex);
        }
        if (main != null) {
            throw new ElasticsearchException(main);
        }
    }

    public static <T extends Throwable> T useOrSuppress(T first, T second) {
        if (first == null) {
            return second;
        }
        first.addSuppressed(second);
        return first;
    }

    public static IOException unwrapCorruption(Throwable t) {
        return t == null ? null : (IOException)ExceptionsHelper.unwrapCausesAndSuppressed(t, cause -> {
            for (Class<? extends IOException> clazz : CORRUPTION_EXCEPTIONS) {
                if (!clazz.isInstance(cause)) continue;
                return true;
            }
            return false;
        }).orElse(null);
    }

    public static Throwable unwrap(Throwable t, Class<?> ... clazzes) {
        if (t != null) {
            Set seen = Collections.newSetFromMap(new IdentityHashMap());
            do {
                if (!seen.add(t)) {
                    return null;
                }
                for (Class<?> clazz : clazzes) {
                    if (!clazz.isInstance(t)) continue;
                    return t;
                }
            } while ((t = t.getCause()) != null);
        }
        return null;
    }

    public static boolean isTransportStoppedForAction(Throwable t, String action) {
        TransportException maybeTransport = (TransportException)ExceptionsHelper.unwrap(t, TransportException.class);
        return maybeTransport != null && (maybeTransport.getMessage().equals("TransportService is closed stopped can't send request") || maybeTransport.getMessage().equals("transport stopped, action: " + action));
    }

    public static boolean reThrowIfNotNull(@Nullable Throwable e) {
        if (e != null) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        return true;
    }

    private static <T extends Throwable> Optional<T> unwrapCausesAndSuppressed(Throwable cause, Predicate<Throwable> predicate) {
        if (predicate.test(cause)) {
            return Optional.of(cause);
        }
        LinkedList<Throwable> queue = new LinkedList<Throwable>();
        queue.add(cause);
        Set seen = Collections.newSetFromMap(new IdentityHashMap());
        while (!queue.isEmpty()) {
            Throwable current = (Throwable)queue.remove();
            if (!seen.add(current)) continue;
            if (predicate.test(current)) {
                return Optional.of(current);
            }
            Collections.addAll(queue, current.getSuppressed());
            if (current.getCause() == null) continue;
            queue.add(current.getCause());
        }
        return Optional.empty();
    }

    public static Optional<Error> maybeError(Throwable cause) {
        return ExceptionsHelper.unwrapCausesAndSuppressed(cause, t -> t instanceof Error);
    }

    public static void maybeDieOnAnotherThread(Throwable throwable) {
        ExceptionsHelper.maybeError(throwable).ifPresent(error -> {
            try {
                String formatted = ExceptionsHelper.formatStackTrace(Thread.currentThread().getStackTrace());
                logger.error("fatal error\n{}", (Object)formatted);
            }
            finally {
                new Thread(() -> {
                    throw error;
                }).start();
            }
        });
    }

    public static ShardOperationFailedException[] groupBy(ShardOperationFailedException[] failures) {
        ArrayList<ShardOperationFailedException> uniqueFailures = new ArrayList<ShardOperationFailedException>();
        HashSet<GroupBy> reasons = new HashSet<GroupBy>();
        for (ShardOperationFailedException failure : failures) {
            GroupBy reason = new GroupBy(failure);
            if (reasons.contains(reason)) continue;
            reasons.add(reason);
            uniqueFailures.add(failure);
        }
        return uniqueFailures.toArray(new ShardOperationFailedException[0]);
    }

    private static class GroupBy {
        final String reason;
        final String index;
        final Class<? extends Throwable> causeType;

        GroupBy(ShardOperationFailedException failure) {
            Index index;
            Throwable cause = failure.getCause();
            String indexName = failure.index();
            if (indexName == null && cause instanceof ElasticsearchException && (index = ((ElasticsearchException)cause).getIndex()) != null) {
                indexName = index.getName();
            }
            this.index = indexName;
            this.reason = cause.getMessage();
            this.causeType = cause.getClass();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GroupBy groupBy = (GroupBy)o;
            return Objects.equals(this.reason, groupBy.reason) && Objects.equals(this.index, groupBy.index) && Objects.equals(this.causeType, groupBy.causeType);
        }

        public int hashCode() {
            return Objects.hash(this.reason, this.index, this.causeType);
        }
    }
}

