/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.bkd;

import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.FutureArrays;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.bkd.HeapPointReader;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.bkd.PointReader;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.bkd.PointValue;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.bkd.PointWriter;

public final class HeapPointWriter
implements PointWriter {
    public final byte[] block;
    final int size;
    final int packedBytesLength;
    final int packedBytesDocIDLength;
    private final byte[] scratch;
    private int nextWrite;
    private boolean closed;
    private HeapPointReader.HeapPointValue pointValue;

    public HeapPointWriter(int size, int packedBytesLength) {
        this.packedBytesDocIDLength = packedBytesLength + 4;
        this.packedBytesLength = packedBytesLength;
        this.block = new byte[this.packedBytesDocIDLength * size];
        this.size = size;
        this.scratch = new byte[this.packedBytesDocIDLength];
        this.pointValue = size > 0 ? new HeapPointReader.HeapPointValue(this.block, packedBytesLength) : null;
    }

    public PointValue getPackedValueSlice(int index) {
        assert (index < this.nextWrite) : "nextWrite=" + this.nextWrite + " vs index=" + index;
        this.pointValue.setOffset(index * this.packedBytesDocIDLength);
        return this.pointValue;
    }

    @Override
    public void append(byte[] packedValue, int docID) {
        assert (!this.closed) : "point writer is already closed";
        assert (packedValue.length == this.packedBytesLength) : "[packedValue] must have length [" + this.packedBytesLength + "] but was [" + packedValue.length + "]";
        assert (this.nextWrite < this.size) : "nextWrite=" + (this.nextWrite + 1) + " vs size=" + this.size;
        System.arraycopy(packedValue, 0, this.block, this.nextWrite * this.packedBytesDocIDLength, this.packedBytesLength);
        int position = this.nextWrite * this.packedBytesDocIDLength + this.packedBytesLength;
        this.block[position] = (byte)(docID >> 24);
        this.block[++position] = (byte)(docID >> 16);
        this.block[++position] = (byte)(docID >> 8);
        this.block[++position] = (byte)(docID >> 0);
        ++this.nextWrite;
    }

    @Override
    public void append(PointValue pointValue) {
        assert (!this.closed) : "point writer is already closed";
        assert (this.nextWrite < this.size) : "nextWrite=" + (this.nextWrite + 1) + " vs size=" + this.size;
        BytesRef packedValueDocID = pointValue.packedValueDocIDBytes();
        assert (packedValueDocID.length == this.packedBytesDocIDLength) : "[packedValue] must have length [" + this.packedBytesDocIDLength + "] but was [" + packedValueDocID.length + "]";
        System.arraycopy(packedValueDocID.bytes, packedValueDocID.offset, this.block, this.nextWrite * this.packedBytesDocIDLength, this.packedBytesDocIDLength);
        ++this.nextWrite;
    }

    public void swap(int i, int j) {
        int indexI = i * this.packedBytesDocIDLength;
        int indexJ = j * this.packedBytesDocIDLength;
        System.arraycopy(this.block, indexI, this.scratch, 0, this.packedBytesDocIDLength);
        System.arraycopy(this.block, indexJ, this.block, indexI, this.packedBytesDocIDLength);
        System.arraycopy(this.scratch, 0, this.block, indexJ, this.packedBytesDocIDLength);
    }

    public int computeCardinality(int from, int to, int numDataDims, int bytesPerDim, int[] commonPrefixLengths) {
        assert (this.packedBytesLength == numDataDims * bytesPerDim);
        int leafCardinality = 1;
        block0: for (int i = from + 1; i < to; ++i) {
            for (int dim = 0; dim < numDataDims; ++dim) {
                int start = dim * bytesPerDim + commonPrefixLengths[dim];
                int end = dim * bytesPerDim + bytesPerDim;
                if (FutureArrays.mismatch(this.block, i * this.packedBytesDocIDLength + start, i * this.packedBytesDocIDLength + end, this.block, (i - 1) * this.packedBytesDocIDLength + start, (i - 1) * this.packedBytesDocIDLength + end) == -1) continue;
                ++leafCardinality;
                continue block0;
            }
        }
        return leafCardinality;
    }

    @Override
    public long count() {
        return this.nextWrite;
    }

    @Override
    public PointReader getReader(long start, long length) {
        assert (this.closed) : "point writer is still open and trying to get a reader";
        assert (start + length <= (long)this.size) : "start=" + start + " length=" + length + " docIDs.length=" + this.size;
        assert (start + length <= (long)this.nextWrite) : "start=" + start + " length=" + length + " nextWrite=" + this.nextWrite;
        return new HeapPointReader(this.block, this.packedBytesLength, (int)start, Math.toIntExact(start + length));
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public void destroy() {
    }

    public String toString() {
        return "HeapPointWriter(count=" + this.nextWrite + " size=" + this.size + ")";
    }
}

