/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.uhighlight;

import java.io.IOException;
import java.text.BreakIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.analysis.Analyzer;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.Term;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.DocIdSetIterator;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.IndexSearcher;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.PrefixQuery;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Query;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.spans.SpanMultiTermQueryWrapper;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.spans.SpanOrQuery;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.spans.SpanQuery;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.uhighlight.CustomFieldHighlighter;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.uhighlight.FieldHighlighter;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.uhighlight.FieldOffsetStrategy;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.uhighlight.PassageFormatter;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.uhighlight.PhraseHelper;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.uhighlight.Snippet;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.uhighlight.SplittingBreakIterator;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.uhighlight.UHComponents;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.uhighlight.UnifiedHighlighter;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.lucene.search.MultiPhrasePrefixQuery;

public class CustomUnifiedHighlighter
extends UnifiedHighlighter {
    public static final char MULTIVAL_SEP_CHAR = '\u0000';
    private static final Snippet[] EMPTY_SNIPPET = new Snippet[0];
    private final UnifiedHighlighter.OffsetSource offsetSource;
    private final String fieldValue;
    private final PassageFormatter passageFormatter;
    private final BreakIterator breakIterator;
    private final Locale breakIteratorLocale;
    private final int noMatchSize;

    public CustomUnifiedHighlighter(IndexSearcher searcher, Analyzer analyzer, UnifiedHighlighter.OffsetSource offsetSource, PassageFormatter passageFormatter, @Nullable Locale breakIteratorLocale, @Nullable BreakIterator breakIterator, String fieldValue, int noMatchSize) {
        super(searcher, analyzer);
        this.offsetSource = offsetSource;
        this.breakIterator = breakIterator;
        this.breakIteratorLocale = breakIteratorLocale == null ? Locale.ROOT : breakIteratorLocale;
        this.passageFormatter = passageFormatter;
        this.fieldValue = fieldValue;
        this.noMatchSize = noMatchSize;
    }

    public Snippet[] highlightField(String field, Query query, int docId, int maxPassages) throws IOException {
        Map<String, Object[]> fieldsAsObjects = super.highlightFieldsAsObjects(new String[]{field}, query, new int[]{docId}, new int[]{maxPassages});
        Object[] snippetObjects = fieldsAsObjects.get(field);
        if (snippetObjects != null) {
            assert (snippetObjects.length == 1);
            Object snippetObject = snippetObjects[0];
            if (snippetObject != null && snippetObject instanceof Snippet[]) {
                return (Snippet[])snippetObject;
            }
        }
        return EMPTY_SNIPPET;
    }

    @Override
    protected List<CharSequence[]> loadFieldValues(String[] fields, DocIdSetIterator docIter, int cacheCharsThreshold) throws IOException {
        return Collections.singletonList(new String[]{this.fieldValue});
    }

    @Override
    protected BreakIterator getBreakIterator(String field) {
        return this.breakIterator;
    }

    @Override
    protected PassageFormatter getFormatter(String field) {
        return this.passageFormatter;
    }

    @Override
    protected FieldHighlighter getFieldHighlighter(String field, Query query, Set<Term> allTerms, int maxPassages) {
        Predicate<String> fieldMatcher = this.getFieldMatcher(field);
        BytesRef[] terms = CustomUnifiedHighlighter.filterExtractedTerms(fieldMatcher, allTerms);
        Set<UnifiedHighlighter.HighlightFlag> highlightFlags = this.getFlags(field);
        PhraseHelper phraseHelper = this.getPhraseHelper(field, query, highlightFlags);
        CharacterRunAutomaton[] automata = this.getAutomata(field, query, highlightFlags);
        UHComponents components = new UHComponents(field, fieldMatcher, query, terms, phraseHelper, automata, false, highlightFlags);
        UnifiedHighlighter.OffsetSource offsetSource = this.getOptimizedOffsetSource(components);
        SplittingBreakIterator breakIterator = new SplittingBreakIterator(this.getBreakIterator(field), '\u0000');
        FieldOffsetStrategy strategy = this.getOffsetStrategy(offsetSource, components);
        return new CustomFieldHighlighter(field, strategy, this.breakIteratorLocale, breakIterator, this.getScorer(field), maxPassages, this.noMatchSize > 0 ? 1 : 0, this.getFormatter(field), this.noMatchSize, this.fieldValue);
    }

    @Override
    protected Collection<Query> preSpanQueryRewrite(Query query) {
        return this.rewriteCustomQuery(query);
    }

    private Collection<Query> rewriteCustomQuery(Query query) {
        if (query instanceof MultiPhrasePrefixQuery) {
            MultiPhrasePrefixQuery mpq = (MultiPhrasePrefixQuery)query;
            Term[][] terms = mpq.getTerms();
            int[] positions = mpq.getPositions();
            SpanQuery[] positionSpanQueries = new SpanQuery[positions.length];
            int sizeMinus1 = terms.length - 1;
            for (int i = 0; i < positions.length; ++i) {
                SpanQuery[] innerQueries = new SpanQuery[terms[i].length];
                for (int j = 0; j < terms[i].length; ++j) {
                    innerQueries[j] = i == sizeMinus1 ? new SpanMultiTermQueryWrapper<PrefixQuery>(new PrefixQuery(terms[i][j])) : new SpanTermQuery(terms[i][j]);
                }
                positionSpanQueries[i] = innerQueries.length > 1 ? new SpanOrQuery(innerQueries) : innerQueries[0];
            }
            if (positionSpanQueries.length == 1) {
                return Collections.singletonList(positionSpanQueries[0]);
            }
            int positionGaps = 0;
            if (positions.length >= 2) {
                positionGaps = Math.max(0, positions[positions.length - 1] - positions[0] - positions.length + 1);
            }
            boolean inorder = mpq.getSlop() == 0;
            return Collections.singletonList(new SpanNearQuery(positionSpanQueries, mpq.getSlop() + positionGaps, inorder));
        }
        return null;
    }

    @Override
    protected UnifiedHighlighter.OffsetSource getOffsetSource(String field) {
        if (this.offsetSource == null) {
            return super.getOffsetSource(field);
        }
        return this.offsetSource;
    }
}

