/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.Term;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.TermStates;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.IndexSearcher;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.ScoreMode;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.spans.ContainSpans;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.spans.SpanContainQuery;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.spans.SpanQuery;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.spans.SpanWeight;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.spans.Spans;

public final class SpanWithinQuery
extends SpanContainQuery {
    public SpanWithinQuery(SpanQuery big, SpanQuery little) {
        super(big, little);
    }

    @Override
    public String toString(String field) {
        return this.toString(field, "SpanWithin");
    }

    @Override
    public SpanWeight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        SpanWeight bigWeight = this.big.createWeight(searcher, scoreMode, boost);
        SpanWeight littleWeight = this.little.createWeight(searcher, scoreMode, boost);
        return new SpanWithinWeight(searcher, scoreMode.needsScores() ? SpanWithinQuery.getTermStates(bigWeight, littleWeight) : null, bigWeight, littleWeight, boost);
    }

    public class SpanWithinWeight
    extends SpanContainQuery.SpanContainWeight {
        public SpanWithinWeight(IndexSearcher searcher, Map<Term, TermStates> terms, SpanWeight bigWeight, SpanWeight littleWeight, float boost) throws IOException {
            super(searcher, terms, bigWeight, littleWeight, boost);
        }

        @Override
        public Spans getSpans(LeafReaderContext context, SpanWeight.Postings requiredPostings) throws IOException {
            ArrayList<Spans> containerContained = this.prepareConjunction(context, requiredPostings);
            if (containerContained == null) {
                return null;
            }
            Spans big = containerContained.get(0);
            Spans little = containerContained.get(1);
            return new ContainSpans(big, little, little){

                @Override
                boolean twoPhaseCurrentDocMatches() throws IOException {
                    this.oneExhaustedInCurrentDoc = false;
                    assert (this.littleSpans.startPosition() == -1);
                    while (this.littleSpans.nextStartPosition() != Integer.MAX_VALUE) {
                        while (this.bigSpans.endPosition() < this.littleSpans.endPosition()) {
                            if (this.bigSpans.nextStartPosition() != Integer.MAX_VALUE) continue;
                            this.oneExhaustedInCurrentDoc = true;
                            return false;
                        }
                        if (this.bigSpans.startPosition() > this.littleSpans.startPosition()) continue;
                        this.atFirstInCurrentDoc = true;
                        return true;
                    }
                    this.oneExhaustedInCurrentDoc = true;
                    return false;
                }

                @Override
                public int nextStartPosition() throws IOException {
                    if (this.atFirstInCurrentDoc) {
                        this.atFirstInCurrentDoc = false;
                        return this.littleSpans.startPosition();
                    }
                    while (this.littleSpans.nextStartPosition() != Integer.MAX_VALUE) {
                        while (this.bigSpans.endPosition() < this.littleSpans.endPosition()) {
                            if (this.bigSpans.nextStartPosition() != Integer.MAX_VALUE) continue;
                            this.oneExhaustedInCurrentDoc = true;
                            return Integer.MAX_VALUE;
                        }
                        if (this.bigSpans.startPosition() > this.littleSpans.startPosition()) continue;
                        return this.littleSpans.startPosition();
                    }
                    this.oneExhaustedInCurrentDoc = true;
                    return Integer.MAX_VALUE;
                }
            };
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return this.littleWeight.isCacheable(ctx) && this.bigWeight.isCacheable(ctx);
        }
    }
}

