/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.similarities;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Explanation;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.similarities.BasicStats;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.similarities.Distribution;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.similarities.Lambda;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.similarities.Normalization;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.similarities.SimilarityBase;

public class IBSimilarity
extends SimilarityBase {
    protected final Distribution distribution;
    protected final Lambda lambda;
    protected final Normalization normalization;

    public IBSimilarity(Distribution distribution, Lambda lambda, Normalization normalization) {
        this.distribution = distribution;
        this.lambda = lambda;
        this.normalization = normalization;
    }

    @Override
    protected double score(BasicStats stats, double freq, double docLen) {
        return stats.getBoost() * this.distribution.score(stats, this.normalization.tfn(stats, freq, docLen), this.lambda.lambda(stats));
    }

    @Override
    protected void explain(List<Explanation> subs, BasicStats stats, double freq, double docLen) {
        if (stats.getBoost() != 1.0) {
            subs.add(Explanation.match((Number)Float.valueOf((float)stats.getBoost()), "boost, query boost", new Explanation[0]));
        }
        Explanation normExpl = this.normalization.explain(stats, freq, docLen);
        Explanation lambdaExpl = this.lambda.explain(stats);
        subs.add(normExpl);
        subs.add(lambdaExpl);
        subs.add(this.distribution.explain(stats, normExpl.getValue().floatValue(), lambdaExpl.getValue().floatValue()));
    }

    @Override
    protected Explanation explain(BasicStats stats, Explanation freq, double docLen) {
        ArrayList<Explanation> subs = new ArrayList<Explanation>();
        this.explain(subs, stats, freq.getValue().doubleValue(), docLen);
        return Explanation.match((Number)Float.valueOf((float)this.score(stats, freq.getValue().doubleValue(), docLen)), "score(" + this.getClass().getSimpleName() + ", freq=" + freq.getValue() + "), computed as boost * distribution.score(stats, normalization.tfn(stats, freq, docLen), lambda.lambda(stats)) from:", subs);
    }

    @Override
    public String toString() {
        return "IB " + this.distribution.toString() + "-" + this.lambda.toString() + this.normalization.toString();
    }

    public Distribution getDistribution() {
        return this.distribution;
    }

    public Lambda getLambda() {
        return this.lambda;
    }

    public Normalization getNormalization() {
        return this.normalization;
    }
}

