/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.DocIdSetIterator;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Scorer;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.TwoPhaseIterator;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.spans.Spans;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.ArrayUtil;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BitSet;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BitSetIterator;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.CollectionUtil;

public final class ConjunctionDISI
extends DocIdSetIterator {
    final DocIdSetIterator lead1;
    final DocIdSetIterator lead2;
    final DocIdSetIterator[] others;

    public static DocIdSetIterator intersectScorers(Collection<Scorer> scorers) {
        if (scorers.size() < 2) {
            throw new IllegalArgumentException("Cannot make a ConjunctionDISI of less than 2 iterators");
        }
        ArrayList<DocIdSetIterator> allIterators = new ArrayList<DocIdSetIterator>();
        ArrayList<TwoPhaseIterator> twoPhaseIterators = new ArrayList<TwoPhaseIterator>();
        for (Scorer scorer : scorers) {
            ConjunctionDISI.addScorer(scorer, allIterators, twoPhaseIterators);
        }
        return ConjunctionDISI.createConjunction(allIterators, twoPhaseIterators);
    }

    public static DocIdSetIterator intersectIterators(List<DocIdSetIterator> iterators) {
        if (iterators.size() < 2) {
            throw new IllegalArgumentException("Cannot make a ConjunctionDISI of less than 2 iterators");
        }
        ArrayList<DocIdSetIterator> allIterators = new ArrayList<DocIdSetIterator>();
        ArrayList<TwoPhaseIterator> twoPhaseIterators = new ArrayList<TwoPhaseIterator>();
        for (DocIdSetIterator iterator : iterators) {
            ConjunctionDISI.addIterator(iterator, allIterators, twoPhaseIterators);
        }
        return ConjunctionDISI.createConjunction(allIterators, twoPhaseIterators);
    }

    public static DocIdSetIterator intersectSpans(List<Spans> spanList) {
        if (spanList.size() < 2) {
            throw new IllegalArgumentException("Cannot make a ConjunctionDISI of less than 2 iterators");
        }
        ArrayList<DocIdSetIterator> allIterators = new ArrayList<DocIdSetIterator>();
        ArrayList<TwoPhaseIterator> twoPhaseIterators = new ArrayList<TwoPhaseIterator>();
        for (Spans spans : spanList) {
            ConjunctionDISI.addSpans(spans, allIterators, twoPhaseIterators);
        }
        return ConjunctionDISI.createConjunction(allIterators, twoPhaseIterators);
    }

    private static void addScorer(Scorer scorer, List<DocIdSetIterator> allIterators, List<TwoPhaseIterator> twoPhaseIterators) {
        TwoPhaseIterator twoPhaseIter = scorer.twoPhaseIterator();
        if (twoPhaseIter != null) {
            ConjunctionDISI.addTwoPhaseIterator(twoPhaseIter, allIterators, twoPhaseIterators);
        } else {
            ConjunctionDISI.addIterator(scorer.iterator(), allIterators, twoPhaseIterators);
        }
    }

    private static void addSpans(Spans spans, List<DocIdSetIterator> allIterators, List<TwoPhaseIterator> twoPhaseIterators) {
        TwoPhaseIterator twoPhaseIter = spans.asTwoPhaseIterator();
        if (twoPhaseIter != null) {
            ConjunctionDISI.addTwoPhaseIterator(twoPhaseIter, allIterators, twoPhaseIterators);
        } else {
            ConjunctionDISI.addIterator(spans, allIterators, twoPhaseIterators);
        }
    }

    private static void addIterator(DocIdSetIterator disi, List<DocIdSetIterator> allIterators, List<TwoPhaseIterator> twoPhaseIterators) {
        TwoPhaseIterator twoPhase = TwoPhaseIterator.unwrap(disi);
        if (twoPhase != null) {
            ConjunctionDISI.addTwoPhaseIterator(twoPhase, allIterators, twoPhaseIterators);
        } else if (disi.getClass() == ConjunctionDISI.class) {
            ConjunctionDISI conjunction = (ConjunctionDISI)disi;
            allIterators.add(conjunction.lead1);
            allIterators.add(conjunction.lead2);
            Collections.addAll(allIterators, conjunction.others);
        } else if (disi.getClass() == BitSetConjunctionDISI.class) {
            BitSetConjunctionDISI conjunction = (BitSetConjunctionDISI)disi;
            allIterators.add(conjunction.lead);
            Collections.addAll(allIterators, conjunction.bitSetIterators);
        } else {
            allIterators.add(disi);
        }
    }

    private static void addTwoPhaseIterator(TwoPhaseIterator twoPhaseIter, List<DocIdSetIterator> allIterators, List<TwoPhaseIterator> twoPhaseIterators) {
        ConjunctionDISI.addIterator(twoPhaseIter.approximation(), allIterators, twoPhaseIterators);
        if (twoPhaseIter.getClass() == ConjunctionTwoPhaseIterator.class) {
            Collections.addAll(twoPhaseIterators, ((ConjunctionTwoPhaseIterator)twoPhaseIter).twoPhaseIterators);
        } else {
            twoPhaseIterators.add(twoPhaseIter);
        }
    }

    private static DocIdSetIterator createConjunction(List<DocIdSetIterator> allIterators, List<TwoPhaseIterator> twoPhaseIterators) {
        long minCost = allIterators.stream().mapToLong(DocIdSetIterator::cost).min().getAsLong();
        ArrayList<BitSetIterator> bitSetIterators = new ArrayList<BitSetIterator>();
        ArrayList<DocIdSetIterator> iterators = new ArrayList<DocIdSetIterator>();
        for (DocIdSetIterator iterator : allIterators) {
            if (iterator.cost() > minCost && iterator instanceof BitSetIterator) {
                bitSetIterators.add((BitSetIterator)iterator);
                continue;
            }
            iterators.add(iterator);
        }
        DocIdSetIterator disi = iterators.size() == 1 ? (DocIdSetIterator)iterators.get(0) : new ConjunctionDISI(iterators);
        if (bitSetIterators.size() > 0) {
            disi = new BitSetConjunctionDISI(disi, bitSetIterators);
        }
        if (!twoPhaseIterators.isEmpty()) {
            disi = TwoPhaseIterator.asDocIdSetIterator(new ConjunctionTwoPhaseIterator(disi, twoPhaseIterators));
        }
        return disi;
    }

    private ConjunctionDISI(List<? extends DocIdSetIterator> iterators) {
        assert (iterators.size() >= 2);
        CollectionUtil.timSort(iterators, new Comparator<DocIdSetIterator>(){

            @Override
            public int compare(DocIdSetIterator o1, DocIdSetIterator o2) {
                return Long.compare(o1.cost(), o2.cost());
            }
        });
        this.lead1 = iterators.get(0);
        this.lead2 = iterators.get(1);
        this.others = iterators.subList(2, iterators.size()).toArray(new DocIdSetIterator[0]);
    }

    private int doNext(int doc) throws IOException {
        block0: while (true) {
            assert (doc == this.lead1.docID());
            int next2 = this.lead2.advance(doc);
            if (next2 != doc && next2 != (doc = this.lead1.advance(next2))) continue;
            for (DocIdSetIterator other : this.others) {
                int next;
                if (other.docID() >= doc || (next = other.advance(doc)) <= doc) continue;
                doc = this.lead1.advance(next);
                continue block0;
            }
            break;
        }
        return doc;
    }

    @Override
    public int advance(int target) throws IOException {
        return this.doNext(this.lead1.advance(target));
    }

    @Override
    public int docID() {
        return this.lead1.docID();
    }

    @Override
    public int nextDoc() throws IOException {
        return this.doNext(this.lead1.nextDoc());
    }

    @Override
    public long cost() {
        return this.lead1.cost();
    }

    private static final class ConjunctionTwoPhaseIterator
    extends TwoPhaseIterator {
        private final TwoPhaseIterator[] twoPhaseIterators;
        private final float matchCost;

        private ConjunctionTwoPhaseIterator(DocIdSetIterator approximation, List<? extends TwoPhaseIterator> twoPhaseIterators) {
            super(approximation);
            assert (twoPhaseIterators.size() > 0);
            CollectionUtil.timSort(twoPhaseIterators, new Comparator<TwoPhaseIterator>(){

                @Override
                public int compare(TwoPhaseIterator o1, TwoPhaseIterator o2) {
                    return Float.compare(o1.matchCost(), o2.matchCost());
                }
            });
            this.twoPhaseIterators = twoPhaseIterators.toArray(new TwoPhaseIterator[twoPhaseIterators.size()]);
            float totalMatchCost = 0.0f;
            for (TwoPhaseIterator twoPhaseIterator : twoPhaseIterators) {
                totalMatchCost += twoPhaseIterator.matchCost();
            }
            this.matchCost = totalMatchCost;
        }

        @Override
        public boolean matches() throws IOException {
            for (TwoPhaseIterator twoPhaseIterator : this.twoPhaseIterators) {
                if (twoPhaseIterator.matches()) continue;
                return false;
            }
            return true;
        }

        @Override
        public float matchCost() {
            return this.matchCost;
        }
    }

    private static class BitSetConjunctionDISI
    extends DocIdSetIterator {
        private final DocIdSetIterator lead;
        private final BitSetIterator[] bitSetIterators;
        private final BitSet[] bitSets;
        private final int minLength;

        BitSetConjunctionDISI(DocIdSetIterator lead, Collection<BitSetIterator> bitSetIterators) {
            this.lead = lead;
            assert (bitSetIterators.size() > 0);
            this.bitSetIterators = bitSetIterators.toArray(new BitSetIterator[0]);
            ArrayUtil.timSort(this.bitSetIterators, (a, b) -> Long.compare(a.cost(), b.cost()));
            this.bitSets = new BitSet[this.bitSetIterators.length];
            int minLen = Integer.MAX_VALUE;
            for (int i = 0; i < this.bitSetIterators.length; ++i) {
                BitSet bitSet;
                this.bitSets[i] = bitSet = this.bitSetIterators[i].getBitSet();
                minLen = Math.min(minLen, bitSet.length());
            }
            this.minLength = minLen;
        }

        @Override
        public int docID() {
            return this.lead.docID();
        }

        @Override
        public int nextDoc() throws IOException {
            return this.doNext(this.lead.nextDoc());
        }

        @Override
        public int advance(int target) throws IOException {
            return this.doNext(this.lead.advance(target));
        }

        private int doNext(int doc) throws IOException {
            while (true) {
                block5: {
                    if (doc >= this.minLength) {
                        return Integer.MAX_VALUE;
                    }
                    for (BitSet bitSet : this.bitSets) {
                        if (bitSet.get(doc)) {
                            continue;
                        }
                        break block5;
                    }
                    for (BitSetIterator iterator : this.bitSetIterators) {
                        iterator.setDocId(doc);
                    }
                    return doc;
                }
                doc = this.lead.nextDoc();
            }
        }

        @Override
        public long cost() {
            return this.lead.cost();
        }
    }
}

