/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.FieldInfos;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.SegmentInfo;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.Directory;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.IOContext;

public class SegmentReadState {
    public final Directory directory;
    public final SegmentInfo segmentInfo;
    public final FieldInfos fieldInfos;
    public final IOContext context;
    public final String segmentSuffix;
    public final boolean openedFromWriter;
    public final Map<String, String> readerAttributes;

    public SegmentReadState(Directory dir, SegmentInfo info, FieldInfos fieldInfos, boolean openedFromWriter, IOContext context, Map<String, String> readerAttributes) {
        this(dir, info, fieldInfos, openedFromWriter, context, "", readerAttributes);
    }

    public SegmentReadState(Directory dir, SegmentInfo info, FieldInfos fieldInfos, boolean openedFromWriter, IOContext context, String segmentSuffix, Map<String, String> readerAttributes) {
        this.directory = dir;
        this.segmentInfo = info;
        this.fieldInfos = fieldInfos;
        this.context = context;
        this.segmentSuffix = segmentSuffix;
        this.openedFromWriter = openedFromWriter;
        this.readerAttributes = Collections.unmodifiableMap(new HashMap<String, String>(readerAttributes));
    }

    public SegmentReadState(SegmentReadState other, String newSegmentSuffix) {
        this.directory = other.directory;
        this.segmentInfo = other.segmentInfo;
        this.fieldInfos = other.fieldInfos;
        this.context = other.context;
        this.openedFromWriter = other.openedFromWriter;
        this.segmentSuffix = newSegmentSuffix;
        this.readerAttributes = other.readerAttributes;
    }
}

