/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.DocumentsWriterPerThread;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.ThreadInterruptedException;

final class DocumentsWriterPerThreadPool {
    private final List<ThreadState> threadStates = new ArrayList<ThreadState>();
    private final List<ThreadState> freeList = new ArrayList<ThreadState>();
    private int takenThreadStatePermits = 0;

    DocumentsWriterPerThreadPool() {
    }

    synchronized int getActiveThreadStateCount() {
        return this.threadStates.size();
    }

    synchronized void lockNewThreadStates() {
        assert (this.takenThreadStatePermits >= 0);
        ++this.takenThreadStatePermits;
    }

    synchronized void unlockNewThreadStates() {
        assert (this.takenThreadStatePermits > 0);
        --this.takenThreadStatePermits;
        if (this.takenThreadStatePermits == 0) {
            this.notifyAll();
        }
    }

    private synchronized ThreadState newThreadState() {
        assert (this.takenThreadStatePermits >= 0);
        while (this.takenThreadStatePermits > 0) {
            try {
                this.wait();
            }
            catch (InterruptedException ie) {
                throw new ThreadInterruptedException(ie);
            }
        }
        ThreadState threadState = new ThreadState(null);
        threadState.lock();
        this.threadStates.add(threadState);
        return threadState;
    }

    DocumentsWriterPerThread reset(ThreadState threadState) {
        assert (threadState.isHeldByCurrentThread());
        DocumentsWriterPerThread dwpt = threadState.dwpt;
        threadState.reset();
        return dwpt;
    }

    void recycle(DocumentsWriterPerThread dwpt) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ThreadState getAndLock() {
        ThreadState threadState = null;
        DocumentsWriterPerThreadPool documentsWriterPerThreadPool = this;
        synchronized (documentsWriterPerThreadPool) {
            if (this.freeList.isEmpty()) {
                return this.newThreadState();
            }
            threadState = this.freeList.remove(this.freeList.size() - 1);
            if (threadState.dwpt == null) {
                for (int i = 0; i < this.freeList.size(); ++i) {
                    ThreadState ts = this.freeList.get(i);
                    if (ts.dwpt == null) continue;
                    this.freeList.set(i, threadState);
                    threadState = ts;
                    break;
                }
            }
        }
        threadState.lock();
        return threadState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release(ThreadState state) {
        state.unlock();
        DocumentsWriterPerThreadPool documentsWriterPerThreadPool = this;
        synchronized (documentsWriterPerThreadPool) {
            this.freeList.add(state);
        }
    }

    synchronized ThreadState getThreadState(int ord) {
        return this.threadStates.get(ord);
    }

    synchronized int getMaxThreadStates() {
        return this.threadStates.size();
    }

    static final class ThreadState
    extends ReentrantLock {
        DocumentsWriterPerThread dwpt;
        volatile boolean flushPending = false;
        long bytesUsed = 0L;
        volatile long lastSeqNo;

        ThreadState(DocumentsWriterPerThread dpwt) {
            this.dwpt = dpwt;
        }

        private void reset() {
            assert (this.isHeldByCurrentThread());
            this.dwpt = null;
            this.bytesUsed = 0L;
            this.flushPending = false;
        }

        boolean isInitialized() {
            assert (this.isHeldByCurrentThread());
            return this.dwpt != null;
        }

        public long getBytesUsedPerThread() {
            assert (this.isHeldByCurrentThread());
            return this.bytesUsed;
        }

        public DocumentsWriterPerThread getDocumentsWriterPerThread() {
            assert (this.isHeldByCurrentThread());
            return this.dwpt;
        }

        public boolean isFlushPending() {
            return this.flushPending;
        }
    }
}

