/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index;

import java.io.IOException;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.DocumentsWriterDeleteQueue;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.DocumentsWriterPerThread;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.FrozenBufferedUpdates;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.IOUtils;

final class DocumentsWriterFlushQueue {
    private final Queue<FlushTicket> queue = new LinkedList<FlushTicket>();
    private final AtomicInteger ticketCount = new AtomicInteger();
    private final ReentrantLock purgeLock = new ReentrantLock();

    DocumentsWriterFlushQueue() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean addDeletes(DocumentsWriterDeleteQueue deleteQueue) throws IOException {
        this.incTickets();
        boolean success = false;
        try {
            FrozenBufferedUpdates frozenBufferedUpdates = deleteQueue.maybeFreezeGlobalBuffer();
            if (frozenBufferedUpdates != null) {
                this.queue.add(new FlushTicket(frozenBufferedUpdates, false));
                success = true;
            }
        }
        finally {
            if (!success) {
                this.decTickets();
            }
        }
        return success;
    }

    private void incTickets() {
        int numTickets = this.ticketCount.incrementAndGet();
        assert (numTickets > 0);
    }

    private void decTickets() {
        int numTickets = this.ticketCount.decrementAndGet();
        assert (numTickets >= 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized FlushTicket addFlushTicket(DocumentsWriterPerThread dwpt) throws IOException {
        this.incTickets();
        boolean success = false;
        try {
            FlushTicket ticket = new FlushTicket(dwpt.prepareFlush(), true);
            this.queue.add(ticket);
            success = true;
            FlushTicket flushTicket = ticket;
            return flushTicket;
        }
        finally {
            if (!success) {
                this.decTickets();
            }
        }
    }

    synchronized void addSegment(FlushTicket ticket, DocumentsWriterPerThread.FlushedSegment segment) {
        assert (ticket.hasSegment);
        ticket.setSegment(segment);
    }

    synchronized void markTicketFailed(FlushTicket ticket) {
        assert (ticket.hasSegment);
        ticket.setFailed();
    }

    boolean hasTickets() {
        assert (this.ticketCount.get() >= 0) : "ticketCount should be >= 0 but was: " + this.ticketCount.get();
        return this.ticketCount.get() != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void innerPurge(IOUtils.IOConsumer<FlushTicket> consumer) throws IOException {
        assert (this.purgeLock.isHeldByCurrentThread());
        while (true) {
            boolean canPublish;
            FlushTicket head;
            DocumentsWriterFlushQueue documentsWriterFlushQueue = this;
            synchronized (documentsWriterFlushQueue) {
                head = this.queue.peek();
                if (head == null) return;
                if (!head.canPublish()) return;
                boolean bl = true;
                canPublish = bl;
            }
            if (!canPublish) return;
            try {
                consumer.accept(head);
                continue;
            }
            finally {
                documentsWriterFlushQueue = this;
                synchronized (documentsWriterFlushQueue) {
                    FlushTicket poll = this.queue.poll();
                    this.decTickets();
                    assert (poll == head);
                }
                continue;
            }
            break;
        }
    }

    void forcePurge(IOUtils.IOConsumer<FlushTicket> consumer) throws IOException {
        assert (!Thread.holdsLock(this));
        this.purgeLock.lock();
        try {
            this.innerPurge(consumer);
        }
        finally {
            this.purgeLock.unlock();
        }
    }

    void tryPurge(IOUtils.IOConsumer<FlushTicket> consumer) throws IOException {
        assert (!Thread.holdsLock(this));
        if (this.purgeLock.tryLock()) {
            try {
                this.innerPurge(consumer);
            }
            finally {
                this.purgeLock.unlock();
            }
        }
    }

    int getTicketCount() {
        return this.ticketCount.get();
    }

    static final class FlushTicket {
        private final FrozenBufferedUpdates frozenUpdates;
        private final boolean hasSegment;
        private DocumentsWriterPerThread.FlushedSegment segment;
        private boolean failed = false;
        private boolean published = false;

        FlushTicket(FrozenBufferedUpdates frozenUpdates, boolean hasSegment) {
            this.frozenUpdates = frozenUpdates;
            this.hasSegment = hasSegment;
        }

        boolean canPublish() {
            return !this.hasSegment || this.segment != null || this.failed;
        }

        synchronized void markPublished() {
            assert (!this.published) : "ticket was already published - can not publish twice";
            this.published = true;
        }

        private void setSegment(DocumentsWriterPerThread.FlushedSegment segment) {
            assert (!this.failed);
            this.segment = segment;
        }

        private void setFailed() {
            assert (this.segment == null);
            this.failed = true;
        }

        DocumentsWriterPerThread.FlushedSegment getFlushedSegment() {
            return this.segment;
        }

        FrozenBufferedUpdates getFrozenUpdates() {
            return this.frozenUpdates;
        }
    }
}

