/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document;

import java.util.Arrays;
import java.util.Collection;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document.Field;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document.FieldType;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document.LongDistanceFeatureQuery;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.IndexableFieldType;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.BoostQuery;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.PointInSetQuery;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.PointRangeQuery;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Query;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.NumericUtils;

public final class LongPoint
extends Field {
    private static FieldType getType(int numDims) {
        FieldType type = new FieldType();
        type.setDimensions(numDims, 8);
        type.freeze();
        return type;
    }

    @Override
    public void setLongValue(long value) {
        this.setLongValues(value);
    }

    public void setLongValues(long ... point) {
        if (this.type.pointDataDimensionCount() != point.length) {
            throw new IllegalArgumentException("this field (name=" + this.name + ") uses " + this.type.pointDataDimensionCount() + " dimensions; cannot change to (incoming) " + point.length + " dimensions");
        }
        this.fieldsData = LongPoint.pack(point);
    }

    @Override
    public void setBytesValue(BytesRef bytes) {
        throw new IllegalArgumentException("cannot change value type from long to BytesRef");
    }

    @Override
    public Number numericValue() {
        if (this.type.pointDataDimensionCount() != 1) {
            throw new IllegalStateException("this field (name=" + this.name + ") uses " + this.type.pointDataDimensionCount() + " dimensions; cannot convert to a single numeric value");
        }
        BytesRef bytes = (BytesRef)this.fieldsData;
        assert (bytes.length == 8);
        return LongPoint.decodeDimension(bytes.bytes, bytes.offset);
    }

    public static BytesRef pack(long ... point) {
        if (point == null) {
            throw new IllegalArgumentException("point must not be null");
        }
        if (point.length == 0) {
            throw new IllegalArgumentException("point must not be 0 dimensions");
        }
        byte[] packed = new byte[point.length * 8];
        for (int dim = 0; dim < point.length; ++dim) {
            LongPoint.encodeDimension(point[dim], packed, dim * 8);
        }
        return new BytesRef(packed);
    }

    public LongPoint(String name, long ... point) {
        super(name, LongPoint.pack(point), (IndexableFieldType)LongPoint.getType(point.length));
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName());
        result.append(" <");
        result.append(this.name);
        result.append(':');
        BytesRef bytes = (BytesRef)this.fieldsData;
        for (int dim = 0; dim < this.type.pointDataDimensionCount(); ++dim) {
            if (dim > 0) {
                result.append(',');
            }
            result.append(LongPoint.decodeDimension(bytes.bytes, bytes.offset + dim * 8));
        }
        result.append('>');
        return result.toString();
    }

    public static void encodeDimension(long value, byte[] dest, int offset) {
        NumericUtils.longToSortableBytes(value, dest, offset);
    }

    public static long decodeDimension(byte[] value, int offset) {
        return NumericUtils.sortableBytesToLong(value, offset);
    }

    public static Query newExactQuery(String field, long value) {
        return LongPoint.newRangeQuery(field, value, value);
    }

    public static Query newRangeQuery(String field, long lowerValue, long upperValue) {
        return LongPoint.newRangeQuery(field, new long[]{lowerValue}, new long[]{upperValue});
    }

    public static Query newRangeQuery(String field, long[] lowerValue, long[] upperValue) {
        PointRangeQuery.checkArgs(field, lowerValue, upperValue);
        return new PointRangeQuery(field, LongPoint.pack((long[])lowerValue).bytes, LongPoint.pack((long[])upperValue).bytes, lowerValue.length){

            @Override
            protected String toString(int dimension, byte[] value) {
                return Long.toString(LongPoint.decodeDimension(value, 0));
            }
        };
    }

    public static Query newSetQuery(String field, long ... values) {
        final long[] sortedValues = (long[])values.clone();
        Arrays.sort(sortedValues);
        final BytesRef encoded = new BytesRef(new byte[8]);
        return new PointInSetQuery(field, 1, 8, new PointInSetQuery.Stream(){
            int upto;

            @Override
            public BytesRef next() {
                if (this.upto == sortedValues.length) {
                    return null;
                }
                LongPoint.encodeDimension(sortedValues[this.upto], encoded.bytes, 0);
                ++this.upto;
                return encoded;
            }
        }){

            @Override
            protected String toString(byte[] value) {
                assert (value.length == 8);
                return Long.toString(LongPoint.decodeDimension(value, 0));
            }
        };
    }

    public static Query newSetQuery(String field, Collection<Long> values) {
        Long[] boxed = values.toArray(new Long[0]);
        long[] unboxed = new long[boxed.length];
        for (int i = 0; i < boxed.length; ++i) {
            unboxed[i] = boxed[i];
        }
        return LongPoint.newSetQuery(field, unboxed);
    }

    public static Query newDistanceFeatureQuery(String field, float weight, long origin, long pivotDistance) {
        Query query = new LongDistanceFeatureQuery(field, origin, pivotDistance);
        if (weight != 1.0f) {
            query = new BoostQuery(query, weight);
        }
        return query;
    }
}

