/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document.Field;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document.LatLonShapeBoundingBoxQuery;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document.LatLonShapeLineQuery;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document.LatLonShapePolygonQuery;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document.ShapeField;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.geo.Line;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.geo.Polygon;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.geo.Tessellator;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Query;

public class LatLonShape {
    private LatLonShape() {
    }

    public static Field[] createIndexableFields(String fieldName, Polygon polygon) {
        List<Tessellator.Triangle> tessellation = Tessellator.tessellate(polygon);
        ArrayList<ShapeField.Triangle> fields = new ArrayList<ShapeField.Triangle>();
        for (Tessellator.Triangle t : tessellation) {
            fields.add(new ShapeField.Triangle(fieldName, t));
        }
        return fields.toArray(new Field[fields.size()]);
    }

    public static Field[] createIndexableFields(String fieldName, Line line) {
        int numPoints = line.numPoints();
        Field[] fields = new Field[numPoints - 1];
        int i = 0;
        for (int j = 1; j < numPoints; ++j) {
            fields[i] = new ShapeField.Triangle(fieldName, GeoEncodingUtils.encodeLongitude(line.getLon(i)), GeoEncodingUtils.encodeLatitude(line.getLat(i)), GeoEncodingUtils.encodeLongitude(line.getLon(j)), GeoEncodingUtils.encodeLatitude(line.getLat(j)), GeoEncodingUtils.encodeLongitude(line.getLon(i)), GeoEncodingUtils.encodeLatitude(line.getLat(i)));
            ++i;
        }
        return fields;
    }

    public static Field[] createIndexableFields(String fieldName, double lat, double lon) {
        return new Field[]{new ShapeField.Triangle(fieldName, GeoEncodingUtils.encodeLongitude(lon), GeoEncodingUtils.encodeLatitude(lat), GeoEncodingUtils.encodeLongitude(lon), GeoEncodingUtils.encodeLatitude(lat), GeoEncodingUtils.encodeLongitude(lon), GeoEncodingUtils.encodeLatitude(lat))};
    }

    public static Query newBoxQuery(String field, ShapeField.QueryRelation queryRelation, double minLatitude, double maxLatitude, double minLongitude, double maxLongitude) {
        return new LatLonShapeBoundingBoxQuery(field, queryRelation, minLatitude, maxLatitude, minLongitude, maxLongitude);
    }

    public static Query newLineQuery(String field, ShapeField.QueryRelation queryRelation, Line ... lines) {
        return new LatLonShapeLineQuery(field, queryRelation, lines);
    }

    public static Query newPolygonQuery(String field, ShapeField.QueryRelation queryRelation, Polygon ... polygons) {
        return new LatLonShapePolygonQuery(field, queryRelation, polygons);
    }
}

