/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.codecs.lucene60;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.codecs.CodecUtil;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.codecs.MutablePointValues;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.codecs.PointsReader;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.codecs.PointsWriter;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.codecs.lucene60.Lucene60PointsReader;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.FieldInfo;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.FieldInfos;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.IndexFileNames;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.MergeState;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.PointValues;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.SegmentWriteState;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.IndexOutput;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.IOUtils;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.bkd.BKDReader;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.bkd.BKDWriter;

public class Lucene60PointsWriter
extends PointsWriter
implements Closeable {
    protected final IndexOutput dataOut;
    protected final Map<String, Long> indexFPs = new HashMap<String, Long>();
    final SegmentWriteState writeState;
    final int maxPointsInLeafNode;
    final double maxMBSortInHeap;
    private boolean finished;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Lucene60PointsWriter(SegmentWriteState writeState, int maxPointsInLeafNode, double maxMBSortInHeap) throws IOException {
        assert (writeState.fieldInfos.hasPointValues());
        this.writeState = writeState;
        this.maxPointsInLeafNode = maxPointsInLeafNode;
        this.maxMBSortInHeap = maxMBSortInHeap;
        String dataFileName = IndexFileNames.segmentFileName(writeState.segmentInfo.name, writeState.segmentSuffix, "dim");
        this.dataOut = writeState.directory.createOutput(dataFileName, writeState.context);
        boolean success = false;
        try {
            CodecUtil.writeIndexHeader(this.dataOut, "Lucene60PointsFormatData", 0, writeState.segmentInfo.getId(), writeState.segmentSuffix);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this.dataOut);
            throw throwable;
        }
    }

    public Lucene60PointsWriter(SegmentWriteState writeState) throws IOException {
        this(writeState, 1024, 16.0);
    }

    @Override
    public void writeField(FieldInfo fieldInfo, PointsReader reader) throws IOException {
        PointValues values = reader.getValues(fieldInfo.name);
        try (final BKDWriter writer = new BKDWriter(this.writeState.segmentInfo.maxDoc(), this.writeState.directory, this.writeState.segmentInfo.name, fieldInfo.getPointDataDimensionCount(), fieldInfo.getPointIndexDimensionCount(), fieldInfo.getPointNumBytes(), this.maxPointsInLeafNode, this.maxMBSortInHeap, values.size());){
            if (values instanceof MutablePointValues) {
                long fp = writer.writeField(this.dataOut, fieldInfo.name, (MutablePointValues)values);
                if (fp != -1L) {
                    this.indexFPs.put(fieldInfo.name, fp);
                }
                return;
            }
            values.intersect(new PointValues.IntersectVisitor(){

                @Override
                public void visit(int docID) {
                    throw new IllegalStateException();
                }

                @Override
                public void visit(int docID, byte[] packedValue) throws IOException {
                    writer.add(packedValue, docID);
                }

                @Override
                public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                    return PointValues.Relation.CELL_CROSSES_QUERY;
                }
            });
            if (writer.getPointCount() > 0L) {
                this.indexFPs.put(fieldInfo.name, writer.finish(this.dataOut));
            }
        }
    }

    @Override
    public void merge(MergeState mergeState) throws IOException {
        for (PointsReader reader : mergeState.pointsReaders) {
            if (reader instanceof Lucene60PointsReader) continue;
            super.merge(mergeState);
            return;
        }
        for (PointsReader reader : mergeState.pointsReaders) {
            if (reader == null) continue;
            reader.checkIntegrity();
        }
        for (FieldInfo fieldInfo : mergeState.mergeFieldInfos) {
            if (fieldInfo.getPointDataDimensionCount() == 0) continue;
            if (fieldInfo.getPointDataDimensionCount() == 1) {
                long totMaxSize = 0L;
                for (int i = 0; i < mergeState.pointsReaders.length; ++i) {
                    PointValues values;
                    FieldInfos readerFieldInfos;
                    FieldInfo readerFieldInfo;
                    PointsReader reader = mergeState.pointsReaders[i];
                    if (reader == null || (readerFieldInfo = (readerFieldInfos = mergeState.fieldInfos[i]).fieldInfo(fieldInfo.name)) == null || readerFieldInfo.getPointDataDimensionCount() <= 0 || (values = reader.getValues(fieldInfo.name)) == null) continue;
                    totMaxSize += values.size();
                }
                BKDWriter writer = new BKDWriter(this.writeState.segmentInfo.maxDoc(), this.writeState.directory, this.writeState.segmentInfo.name, fieldInfo.getPointDataDimensionCount(), fieldInfo.getPointIndexDimensionCount(), fieldInfo.getPointNumBytes(), this.maxPointsInLeafNode, this.maxMBSortInHeap, totMaxSize);
                Throwable throwable = null;
                try {
                    ArrayList<BKDReader> bkdReaders = new ArrayList<BKDReader>();
                    ArrayList<MergeState.DocMap> docMaps = new ArrayList<MergeState.DocMap>();
                    for (int i = 0; i < mergeState.pointsReaders.length; ++i) {
                        BKDReader bkdReader;
                        PointsReader reader = mergeState.pointsReaders[i];
                        if (reader == null) continue;
                        assert (reader instanceof Lucene60PointsReader);
                        Lucene60PointsReader reader60 = (Lucene60PointsReader)reader;
                        FieldInfos readerFieldInfos = mergeState.fieldInfos[i];
                        FieldInfo readerFieldInfo = readerFieldInfos.fieldInfo(fieldInfo.name);
                        if (readerFieldInfo == null || readerFieldInfo.getPointDataDimensionCount() <= 0 || (bkdReader = reader60.readers.get(readerFieldInfo.number)) == null) continue;
                        bkdReaders.add(bkdReader);
                        docMaps.add(mergeState.docMaps[i]);
                    }
                    long fp = writer.merge(this.dataOut, docMaps, bkdReaders);
                    if (fp == -1L) continue;
                    this.indexFPs.put(fieldInfo.name, fp);
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (writer == null) continue;
                    if (throwable != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    writer.close();
                    continue;
                }
            }
            this.mergeOneField(mergeState, fieldInfo);
        }
        this.finish();
    }

    @Override
    public void finish() throws IOException {
        if (this.finished) {
            throw new IllegalStateException("already finished");
        }
        this.finished = true;
        CodecUtil.writeFooter(this.dataOut);
        String indexFileName = IndexFileNames.segmentFileName(this.writeState.segmentInfo.name, this.writeState.segmentSuffix, "dii");
        try (IndexOutput indexOut = this.writeState.directory.createOutput(indexFileName, this.writeState.context);){
            CodecUtil.writeIndexHeader(indexOut, "Lucene60PointsFormatMeta", 0, this.writeState.segmentInfo.getId(), this.writeState.segmentSuffix);
            int count = this.indexFPs.size();
            indexOut.writeVInt(count);
            for (Map.Entry<String, Long> ent : this.indexFPs.entrySet()) {
                FieldInfo fieldInfo = this.writeState.fieldInfos.fieldInfo(ent.getKey());
                if (fieldInfo == null) {
                    throw new IllegalStateException("wrote field=\"" + ent.getKey() + "\" but that field doesn't exist in FieldInfos");
                }
                indexOut.writeVInt(fieldInfo.number);
                indexOut.writeVLong(ent.getValue());
            }
            CodecUtil.writeFooter(indexOut);
        }
    }

    @Override
    public void close() throws IOException {
        this.dataOut.close();
    }
}

