/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.codecs;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.Impact;

public final class CompetitiveImpactAccumulator {
    private final int[] maxFreqs = new int[256];
    private boolean dirty;
    private final TreeSet<Impact> freqNormPairs;

    public CompetitiveImpactAccumulator() {
        Comparator<Impact> comparator = new Comparator<Impact>(){

            @Override
            public int compare(Impact o1, Impact o2) {
                int cmp = Integer.compare(o1.freq, o2.freq);
                if (cmp == 0) {
                    cmp = Long.compareUnsigned(o2.norm, o1.norm);
                }
                return cmp;
            }
        };
        this.freqNormPairs = new TreeSet<Impact>(comparator);
    }

    public void clear() {
        Arrays.fill(this.maxFreqs, 0);
        this.dirty = false;
        this.freqNormPairs.clear();
    }

    public void add(int freq, long norm) {
        if (norm >= -128L && norm <= 127L) {
            int index = Byte.toUnsignedInt((byte)norm);
            this.maxFreqs[index] = Math.max(this.maxFreqs[index], freq);
            this.dirty = true;
        } else {
            this.add(new Impact(freq, norm));
        }
    }

    public void addAll(CompetitiveImpactAccumulator acc) {
        for (Impact entry : acc.getCompetitiveFreqNormPairs()) {
            this.add(entry);
        }
    }

    public SortedSet<Impact> getCompetitiveFreqNormPairs() {
        if (this.dirty) {
            for (int i = 0; i < this.maxFreqs.length; ++i) {
                if (this.maxFreqs[i] <= 0) continue;
                this.add(new Impact(this.maxFreqs[i], (byte)i));
                this.maxFreqs[i] = 0;
            }
            this.dirty = false;
        }
        return Collections.unmodifiableSortedSet(this.freqNormPairs);
    }

    private void add(Impact newEntry) {
        Impact next = this.freqNormPairs.ceiling(newEntry);
        if (next == null) {
            this.freqNormPairs.add(newEntry);
        } else {
            if (Long.compareUnsigned(next.norm, newEntry.norm) <= 0) {
                return;
            }
            this.freqNormPairs.add(newEntry);
        }
        Iterator<Impact> it = this.freqNormPairs.headSet(newEntry, false).descendingIterator();
        while (it.hasNext()) {
            Impact entry = it.next();
            if (Long.compareUnsigned(entry.norm, newEntry.norm) < 0) break;
            it.remove();
        }
    }

    public String toString() {
        return this.getCompetitiveFreqNormPairs().toString();
    }
}

