/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.analysis;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.analysis.TokenFilter;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.analysis.TokenStream;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.analysis.tokenattributes.PositionLengthAttribute;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.AttributeSource;

public abstract class GraphTokenFilter
extends TokenFilter {
    private final Deque<Token> tokenPool = new ArrayDeque<Token>();
    private final List<Token> currentGraph = new ArrayList<Token>();
    public static final int MAX_GRAPH_STACK_SIZE = 1000;
    public static final int MAX_TOKEN_CACHE_SIZE = 100;
    private Token baseToken;
    private int graphDepth;
    private int graphPos;
    private int trailingPositions = -1;
    private int finalOffsets = -1;
    private int stackSize;
    private int cacheSize;
    private final PositionIncrementAttribute posIncAtt;
    private final OffsetAttribute offsetAtt;

    public GraphTokenFilter(TokenStream input) {
        super(input);
        this.posIncAtt = input.addAttribute(PositionIncrementAttribute.class);
        this.offsetAtt = input.addAttribute(OffsetAttribute.class);
    }

    protected final boolean incrementBaseToken() throws IOException {
        this.stackSize = 0;
        this.graphDepth = 0;
        this.graphPos = 0;
        Token oldBase = this.baseToken;
        this.baseToken = this.nextTokenInStream(this.baseToken);
        if (this.baseToken == null) {
            return false;
        }
        this.currentGraph.clear();
        this.currentGraph.add(this.baseToken);
        this.baseToken.attSource.copyTo(this);
        this.recycleToken(oldBase);
        return true;
    }

    protected final boolean incrementGraphToken() throws IOException {
        if (this.graphPos < this.graphDepth) {
            ++this.graphPos;
            this.currentGraph.get((int)this.graphPos).attSource.copyTo(this);
            return true;
        }
        Token token = this.nextTokenInGraph(this.currentGraph.get(this.graphDepth));
        if (token == null) {
            return false;
        }
        ++this.graphDepth;
        ++this.graphPos;
        this.currentGraph.add(this.graphDepth, token);
        token.attSource.copyTo(this);
        return true;
    }

    protected final boolean incrementGraph() throws IOException {
        if (this.baseToken == null) {
            return false;
        }
        this.graphPos = 0;
        for (int i = this.graphDepth; i >= 1; --i) {
            if (this.lastInStack(this.currentGraph.get(i))) continue;
            this.currentGraph.set(i, this.nextTokenInStream(this.currentGraph.get(i)));
            for (int j = i + 1; j < this.graphDepth; ++j) {
                this.currentGraph.set(j, this.nextTokenInGraph(this.currentGraph.get(j)));
            }
            if (this.stackSize++ > 1000) {
                throw new IllegalStateException("Too many graph paths (> 1000)");
            }
            this.currentGraph.get((int)0).attSource.copyTo(this);
            this.graphDepth = i;
            return true;
        }
        return false;
    }

    public int getTrailingPositions() {
        return this.trailingPositions;
    }

    @Override
    public void end() throws IOException {
        if (this.trailingPositions == -1) {
            this.input.end();
            this.trailingPositions = this.posIncAtt.getPositionIncrement();
            this.finalOffsets = this.offsetAtt.endOffset();
        } else {
            this.endAttributes();
            this.posIncAtt.setPositionIncrement(this.trailingPositions);
            this.offsetAtt.setOffset(this.finalOffsets, this.finalOffsets);
        }
    }

    @Override
    public void reset() throws IOException {
        this.input.reset();
        this.tokenPool.clear();
        this.cacheSize = 0;
        this.graphDepth = 0;
        this.trailingPositions = -1;
        this.finalOffsets = -1;
        this.baseToken = null;
    }

    int cachedTokenCount() {
        return this.cacheSize;
    }

    private Token newToken() {
        if (this.tokenPool.size() == 0) {
            ++this.cacheSize;
            if (this.cacheSize > 100) {
                throw new IllegalStateException("Too many cached tokens (> 100)");
            }
            return new Token(this.cloneAttributes());
        }
        Token token = this.tokenPool.removeFirst();
        token.reset(this.input);
        return token;
    }

    private void recycleToken(Token token) {
        if (token == null) {
            return;
        }
        token.nextToken = null;
        this.tokenPool.add(token);
    }

    private Token nextTokenInGraph(Token token) throws IOException {
        int remaining = token.length();
        do {
            if ((token = this.nextTokenInStream(token)) != null) continue;
            return null;
        } while ((remaining -= token.posInc()) > 0);
        return token;
    }

    private boolean lastInStack(Token token) throws IOException {
        Token next = this.nextTokenInStream(token);
        return next == null || next.posInc() != 0;
    }

    private Token nextTokenInStream(Token token) throws IOException {
        if (token != null && token.nextToken != null) {
            return token.nextToken;
        }
        if (this.trailingPositions != -1) {
            return null;
        }
        if (!this.input.incrementToken()) {
            this.input.end();
            this.trailingPositions = this.posIncAtt.getPositionIncrement();
            this.finalOffsets = this.offsetAtt.endOffset();
            return null;
        }
        if (token == null) {
            return this.newToken();
        }
        token.nextToken = this.newToken();
        return token.nextToken;
    }

    private static class Token {
        final AttributeSource attSource;
        final PositionIncrementAttribute posIncAtt;
        final PositionLengthAttribute lengthAtt;
        Token nextToken;

        Token(AttributeSource attSource) {
            this.attSource = attSource;
            this.posIncAtt = attSource.addAttribute(PositionIncrementAttribute.class);
            boolean hasLengthAtt = attSource.hasAttribute(PositionLengthAttribute.class);
            this.lengthAtt = hasLengthAtt ? attSource.addAttribute(PositionLengthAttribute.class) : null;
        }

        int posInc() {
            return this.posIncAtt.getPositionIncrement();
        }

        int length() {
            if (this.lengthAtt == null) {
                return 1;
            }
            return this.lengthAtt.getPositionLength();
        }

        void reset(AttributeSource attSource) {
            attSource.copyTo(this.attSource);
            this.nextToken = null;
        }

        public String toString() {
            return this.attSource.toString();
        }
    }
}

