/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.watcher;

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.inject.Inject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.Setting;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.unit.TimeValue;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.threadpool.Scheduler;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.threadpool.ThreadPool;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.watcher.ResourceWatcher;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.watcher.WatcherHandle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResourceWatcherService
extends AbstractLifecycleComponent {
    private static final Logger logger = LogManager.getLogger(ResourceWatcherService.class);
    public static final Setting<Boolean> ENABLED = Setting.boolSetting("resource.reload.enabled", true, Setting.Property.NodeScope);
    public static final Setting<TimeValue> RELOAD_INTERVAL_HIGH = Setting.timeSetting("resource.reload.interval.high", Frequency.HIGH.interval, Setting.Property.NodeScope);
    public static final Setting<TimeValue> RELOAD_INTERVAL_MEDIUM = Setting.timeSetting("resource.reload.interval.medium", Setting.timeSetting("resource.reload.interval", Frequency.MEDIUM.interval, new Setting.Property[0]), Setting.Property.NodeScope);
    public static final Setting<TimeValue> RELOAD_INTERVAL_LOW = Setting.timeSetting("resource.reload.interval.low", Frequency.LOW.interval, Setting.Property.NodeScope);
    private final boolean enabled;
    private final ThreadPool threadPool;
    final ResourceMonitor lowMonitor;
    final ResourceMonitor mediumMonitor;
    final ResourceMonitor highMonitor;
    private volatile Scheduler.Cancellable lowFuture;
    private volatile Scheduler.Cancellable mediumFuture;
    private volatile Scheduler.Cancellable highFuture;

    @Inject
    public ResourceWatcherService(Settings settings, ThreadPool threadPool) {
        this.enabled = ENABLED.get(settings);
        this.threadPool = threadPool;
        TimeValue interval = RELOAD_INTERVAL_LOW.get(settings);
        this.lowMonitor = new ResourceMonitor(interval, Frequency.LOW);
        interval = RELOAD_INTERVAL_MEDIUM.get(settings);
        this.mediumMonitor = new ResourceMonitor(interval, Frequency.MEDIUM);
        interval = RELOAD_INTERVAL_HIGH.get(settings);
        this.highMonitor = new ResourceMonitor(interval, Frequency.HIGH);
    }

    @Override
    protected void doStart() {
        if (!this.enabled) {
            return;
        }
        this.lowFuture = this.threadPool.scheduleWithFixedDelay(this.lowMonitor, this.lowMonitor.interval, "same");
        this.mediumFuture = this.threadPool.scheduleWithFixedDelay(this.mediumMonitor, this.mediumMonitor.interval, "same");
        this.highFuture = this.threadPool.scheduleWithFixedDelay(this.highMonitor, this.highMonitor.interval, "same");
    }

    @Override
    protected void doStop() {
        if (!this.enabled) {
            return;
        }
        this.lowFuture.cancel();
        this.mediumFuture.cancel();
        this.highFuture.cancel();
    }

    @Override
    protected void doClose() {
    }

    public <W extends ResourceWatcher> WatcherHandle<W> add(W watcher) throws IOException {
        return this.add(watcher, Frequency.MEDIUM);
    }

    public <W extends ResourceWatcher> WatcherHandle<W> add(W watcher, Frequency frequency) throws IOException {
        watcher.init();
        switch (frequency) {
            case LOW: {
                return this.lowMonitor.add(watcher);
            }
            case MEDIUM: {
                return this.mediumMonitor.add(watcher);
            }
            case HIGH: {
                return this.highMonitor.add(watcher);
            }
        }
        throw new IllegalArgumentException("Unknown frequency [" + (Object)((Object)frequency) + "]");
    }

    public void notifyNow() {
        this.notifyNow(Frequency.MEDIUM);
    }

    public void notifyNow(Frequency frequency) {
        switch (frequency) {
            case LOW: {
                this.lowMonitor.run();
                break;
            }
            case MEDIUM: {
                this.mediumMonitor.run();
                break;
            }
            case HIGH: {
                this.highMonitor.run();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown frequency [" + (Object)((Object)frequency) + "]");
            }
        }
    }

    class ResourceMonitor
    implements Runnable {
        final TimeValue interval;
        final Frequency frequency;
        final Set<ResourceWatcher> watchers = new CopyOnWriteArraySet<ResourceWatcher>();

        private ResourceMonitor(TimeValue interval, Frequency frequency) {
            this.interval = interval;
            this.frequency = frequency;
        }

        private <W extends ResourceWatcher> WatcherHandle<W> add(W watcher) {
            this.watchers.add(watcher);
            return new WatcherHandle<W>(this, watcher);
        }

        @Override
        public synchronized void run() {
            for (ResourceWatcher watcher : this.watchers) {
                try {
                    watcher.checkAndNotify();
                }
                catch (IOException e) {
                    logger.trace("failed to check resource watcher", (Throwable)e);
                }
            }
        }
    }

    public static enum Frequency {
        HIGH(TimeValue.timeValueSeconds(5L)),
        MEDIUM(TimeValue.timeValueSeconds(30L)),
        LOW(TimeValue.timeValueSeconds(60L));

        final TimeValue interval;

        private Frequency(TimeValue interval) {
            this.interval = interval;
        }
    }
}

