/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.tasks;

import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.tasks.Task;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.tasks.TaskId;

public abstract class CancellableTask
extends Task {
    private final AtomicReference<String> reason = new AtomicReference();

    public CancellableTask(long id, String type, String action, String description, TaskId parentTaskId, Map<String, String> headers) {
        super(id, type, action, description, parentTaskId, headers);
    }

    final void cancel(String reason) {
        assert (reason != null);
        this.reason.compareAndSet(null, reason);
        this.onCancelled();
    }

    public boolean cancelOnParentLeaving() {
        return true;
    }

    public abstract boolean shouldCancelChildrenOnCancellation();

    public boolean isCancelled() {
        return this.reason.get() != null;
    }

    @Nullable
    public String getReasonCancelled() {
        return this.reason.get();
    }

    protected void onCancelled() {
    }
}

