/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.query;

import java.io.IOException;
import java.util.Map;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.IndicesRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.OriginalIndices;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.search.SearchTask;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.IndicesOptions;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.dfs.AggregatedDfs;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.tasks.Task;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.tasks.TaskId;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportRequest;

public class QuerySearchRequest
extends TransportRequest
implements IndicesRequest {
    private long id;
    private AggregatedDfs dfs;
    private OriginalIndices originalIndices;

    public QuerySearchRequest() {
    }

    public QuerySearchRequest(OriginalIndices originalIndices, long id, AggregatedDfs dfs) {
        this.id = id;
        this.dfs = dfs;
        this.originalIndices = originalIndices;
    }

    public QuerySearchRequest(StreamInput in) throws IOException {
        super(in);
        this.id = in.readLong();
        this.dfs = new AggregatedDfs(in);
        this.originalIndices = OriginalIndices.readOriginalIndices(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.id);
        this.dfs.writeTo(out);
        OriginalIndices.writeOriginalIndices(this.originalIndices, out);
    }

    public long id() {
        return this.id;
    }

    public AggregatedDfs dfs() {
        return this.dfs;
    }

    @Override
    public String[] indices() {
        return this.originalIndices.indices();
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.originalIndices.indicesOptions();
    }

    @Override
    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        return new SearchTask(id, type, action, this.getDescription(), parentTaskId, headers);
    }

    @Override
    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("id[");
        sb.append(this.id);
        sb.append("], ");
        sb.append("indices[");
        Strings.arrayToDelimitedString(this.originalIndices.indices(), ",", sb);
        sb.append("]");
        return sb.toString();
    }
}

