/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.internal;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.DirectoryReader;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.IndexReader;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.Term;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.BulkScorer;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.CollectionStatistics;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.CollectionTerminatedException;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Collector;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.ConjunctionDISI;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.DocIdSetIterator;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Explanation;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.IndexSearcher;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.LeafCollector;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Query;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.QueryCache;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.QueryCachingPolicy;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.ScoreMode;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Scorer;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.TermStatistics;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Weight;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.similarities.Similarity;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BitSet;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BitSetIterator;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.Bits;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.CombinedBitSet;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.SparseFixedBitSet;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.dfs.AggregatedDfs;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.internal.CancellableBulkScorer;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.profile.Timer;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.profile.query.ProfileWeight;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.profile.query.QueryProfileBreakdown;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.profile.query.QueryProfiler;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.profile.query.QueryTimingType;

public class ContextIndexSearcher
extends IndexSearcher {
    private static int CHECK_CANCELLED_SCORER_INTERVAL = 2048;
    private AggregatedDfs aggregatedDfs;
    private QueryProfiler profiler;
    private Runnable checkCancelled;

    public ContextIndexSearcher(IndexReader reader, Similarity similarity, QueryCache queryCache, QueryCachingPolicy queryCachingPolicy) {
        super(reader);
        this.setSimilarity(similarity);
        this.setQueryCache(queryCache);
        this.setQueryCachingPolicy(queryCachingPolicy);
    }

    public void setProfiler(QueryProfiler profiler) {
        this.profiler = profiler;
    }

    public void setCheckCancelled(Runnable checkCancelled) {
        this.checkCancelled = checkCancelled;
    }

    public void setAggregatedDfs(AggregatedDfs aggregatedDfs) {
        this.aggregatedDfs = aggregatedDfs;
    }

    @Override
    public Query rewrite(Query original) throws IOException {
        if (this.profiler != null) {
            this.profiler.startRewriteTime();
        }
        try {
            Query query = super.rewrite(original);
            return query;
        }
        finally {
            if (this.profiler != null) {
                this.profiler.stopAndAddRewriteTime();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Weight createWeight(Query query, ScoreMode scoreMode, float boost) throws IOException {
        if (this.profiler != null) {
            Weight weight;
            QueryProfileBreakdown profile = (QueryProfileBreakdown)this.profiler.getQueryBreakdown(query);
            Timer timer = profile.getTimer(QueryTimingType.CREATE_WEIGHT);
            timer.start();
            try {
                weight = super.createWeight(query, scoreMode, boost);
            }
            finally {
                timer.stop();
                this.profiler.pollLastElement();
            }
            return new ProfileWeight(query, weight, profile);
        }
        return super.createWeight(query, scoreMode, boost);
    }

    @Override
    protected void search(List<LeafReaderContext> leaves, final Weight weight, Collector collector) throws IOException {
        Weight cancellableWeight = this.checkCancelled != null ? new Weight(weight.getQuery()){

            @Override
            public void extractTerms(Set<Term> terms) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Explanation explain(LeafReaderContext context, int doc) throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                return weight.scorer(context);
            }

            @Override
            public BulkScorer bulkScorer(LeafReaderContext context) throws IOException {
                BulkScorer in = weight.bulkScorer(context);
                if (in != null) {
                    return new CancellableBulkScorer(in, ContextIndexSearcher.this.checkCancelled);
                }
                return null;
            }
        } : weight;
        this.searchInternal(leaves, cancellableWeight, collector);
    }

    private void searchInternal(List<LeafReaderContext> leaves, Weight weight, Collector collector) throws IOException {
        for (LeafReaderContext ctx : leaves) {
            LeafCollector leafCollector;
            try {
                leafCollector = collector.getLeafCollector(ctx);
            }
            catch (CollectionTerminatedException e) {
                continue;
            }
            Bits liveDocs = ctx.reader().getLiveDocs();
            BitSet liveDocsBitSet = ContextIndexSearcher.getSparseBitSetOrNull(liveDocs);
            if (liveDocsBitSet == null) {
                BulkScorer bulkScorer = weight.bulkScorer(ctx);
                if (bulkScorer == null) continue;
                try {
                    bulkScorer.score(leafCollector, liveDocs);
                }
                catch (CollectionTerminatedException collectionTerminatedException) {}
                continue;
            }
            Scorer scorer = weight.scorer(ctx);
            if (scorer == null) continue;
            try {
                ContextIndexSearcher.intersectScorerAndBitSet(scorer, liveDocsBitSet, leafCollector, this.checkCancelled == null ? () -> {} : this.checkCancelled);
            }
            catch (CollectionTerminatedException collectionTerminatedException) {}
        }
    }

    private static BitSet getSparseBitSetOrNull(Bits liveDocs) {
        if (liveDocs instanceof SparseFixedBitSet) {
            return (BitSet)liveDocs;
        }
        if (liveDocs instanceof CombinedBitSet && ((CombinedBitSet)liveDocs).getFirst() instanceof SparseFixedBitSet) {
            return (BitSet)liveDocs;
        }
        return null;
    }

    static void intersectScorerAndBitSet(Scorer scorer, BitSet acceptDocs, LeafCollector collector, Runnable checkCancelled) throws IOException {
        collector.setScorer(scorer);
        DocIdSetIterator iterator = ConjunctionDISI.intersectIterators(Arrays.asList(new BitSetIterator(acceptDocs, acceptDocs.approximateCardinality()), scorer.iterator()));
        int seen = 0;
        checkCancelled.run();
        int docId = iterator.nextDoc();
        while (docId < Integer.MAX_VALUE) {
            if (++seen % CHECK_CANCELLED_SCORER_INTERVAL == 0) {
                checkCancelled.run();
            }
            collector.collect(docId);
            docId = iterator.nextDoc();
        }
        checkCancelled.run();
    }

    @Override
    public TermStatistics termStatistics(Term term, int docFreq, long totalTermFreq) throws IOException {
        if (this.aggregatedDfs == null) {
            return super.termStatistics(term, docFreq, totalTermFreq);
        }
        TermStatistics termStatistics = this.aggregatedDfs.termStatistics().get(term);
        if (termStatistics == null) {
            return super.termStatistics(term, docFreq, totalTermFreq);
        }
        return termStatistics;
    }

    @Override
    public CollectionStatistics collectionStatistics(String field) throws IOException {
        if (this.aggregatedDfs == null) {
            return super.collectionStatistics(field);
        }
        CollectionStatistics collectionStatistics = this.aggregatedDfs.fieldStatistics().get(field);
        if (collectionStatistics == null) {
            return super.collectionStatistics(field);
        }
        return collectionStatistics;
    }

    public DirectoryReader getDirectoryReader() {
        IndexReader reader = this.getIndexReader();
        assert (reader instanceof DirectoryReader) : "expected an instance of DirectoryReader, got " + reader.getClass();
        return (DirectoryReader)reader;
    }
}

