/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.subphase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.DocValuesIterator;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.ReaderUtil;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.SortedNumericDocValues;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.document.DocumentField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.logging.DeprecationLogger;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.AtomicFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.plain.SortedNumericDVIndexFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MappedFieldType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.DocValueFormat;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.SearchHit;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.FetchSubPhase;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.subphase.DocValueFieldsContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.internal.SearchContext;
import org.apache.logging.log4j.LogManager;

public final class DocValueFieldsFetchSubPhase
implements FetchSubPhase {
    private static final String USE_DEFAULT_FORMAT = "use_field_mapping";
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(LogManager.getLogger(DocValueFieldsFetchSubPhase.class));

    @Override
    public void hitsExecute(SearchContext context, SearchHit[] hits) throws IOException {
        if (context.collapse() != null) {
            String name = context.collapse().getFieldName();
            if (context.docValueFieldsContext() == null) {
                context.docValueFieldsContext(new DocValueFieldsContext(Collections.singletonList(new DocValueFieldsContext.FieldAndFormat(name, null))));
            } else if (!context.docValueFieldsContext().fields().stream().map(ff -> ff.field).anyMatch(name::equals)) {
                context.docValueFieldsContext().fields().add(new DocValueFieldsContext.FieldAndFormat(name, null));
            }
        }
        if (context.docValueFieldsContext() == null) {
            return;
        }
        hits = (SearchHit[])hits.clone();
        Arrays.sort(hits, Comparator.comparingInt(SearchHit::docId));
        if (context.docValueFieldsContext().fields().stream().map(f -> f.format).filter(USE_DEFAULT_FORMAT::equals).findAny().isPresent()) {
            DEPRECATION_LOGGER.deprecated("[use_field_mapping] is a special format that was only used to ease the transition to 7.x. It has become the default and shouldn't be set explicitly anymore.", new Object[0]);
        }
        for (DocValueFieldsContext.FieldAndFormat fieldAndFormat : context.docValueFieldsContext().fields()) {
            String field = fieldAndFormat.field;
            MappedFieldType fieldType = context.mapperService().fullName(field);
            if (fieldType == null) continue;
            Object indexFieldData = context.getForField(fieldType);
            boolean isNanosecond = indexFieldData instanceof IndexNumericFieldData ? ((IndexNumericFieldData)indexFieldData).getNumericType() == IndexNumericFieldData.NumericType.DATE_NANOSECONDS : false;
            String formatDesc = fieldAndFormat.format;
            if (Objects.equals(formatDesc, USE_DEFAULT_FORMAT)) {
                formatDesc = null;
            }
            DocValueFormat format = isNanosecond ? DocValueFormat.withNanosecondResolution(fieldType.docValueFormat(formatDesc, null)) : fieldType.docValueFormat(formatDesc, null);
            LeafReaderContext subReaderContext = null;
            AtomicFieldData data = null;
            SortedBinaryDocValues binaryValues = null;
            DocValuesIterator longValues = null;
            SortedNumericDoubleValues doubleValues = null;
            for (SearchHit hit : hits) {
                int i;
                int count;
                DocumentField hitField;
                if (subReaderContext == null || hit.docId() >= subReaderContext.docBase + subReaderContext.reader().maxDoc()) {
                    int readerIndex = ReaderUtil.subIndex(hit.docId(), context.searcher().getIndexReader().leaves());
                    subReaderContext = context.searcher().getIndexReader().leaves().get(readerIndex);
                    data = (AtomicFieldData)indexFieldData.load(subReaderContext);
                    if (indexFieldData instanceof IndexNumericFieldData) {
                        IndexNumericFieldData.NumericType numericType = ((IndexNumericFieldData)indexFieldData).getNumericType();
                        if (numericType.isFloatingPoint()) {
                            doubleValues = ((AtomicNumericFieldData)data).getDoubleValues();
                        } else {
                            longValues = isNanosecond ? ((SortedNumericDVIndexFieldData.NanoSecondFieldData)data).getLongValuesAsNanos() : ((AtomicNumericFieldData)data).getLongValues();
                        }
                    } else {
                        data = (AtomicFieldData)indexFieldData.load(subReaderContext);
                        binaryValues = data.getBytesValues();
                    }
                }
                if (hit.fieldsOrNull() == null) {
                    hit.fields(new HashMap<String, DocumentField>(2));
                }
                if ((hitField = hit.getFields().get(field)) == null) {
                    hitField = new DocumentField(field, new ArrayList<Object>(2));
                    hit.getFields().put(field, hitField);
                }
                List<Object> values = hitField.getValues();
                int subDocId = hit.docId() - subReaderContext.docBase;
                if (binaryValues != null) {
                    if (!binaryValues.advanceExact(subDocId)) continue;
                    count = binaryValues.docValueCount();
                    for (i = 0; i < count; ++i) {
                        values.add(format.format(binaryValues.nextValue()));
                    }
                    continue;
                }
                if (longValues != null) {
                    if (!longValues.advanceExact(subDocId)) continue;
                    count = ((SortedNumericDocValues)longValues).docValueCount();
                    for (i = 0; i < count; ++i) {
                        values.add(format.format(((SortedNumericDocValues)longValues).nextValue()));
                    }
                    continue;
                }
                if (doubleValues != null) {
                    if (!doubleValues.advanceExact(subDocId)) continue;
                    count = doubleValues.docValueCount();
                    for (i = 0; i < count; ++i) {
                        values.add(format.format(doubleValues.nextValue()));
                    }
                    continue;
                }
                throw new AssertionError((Object)"Unreachable code");
            }
        }
    }
}

